/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.util.jvm;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.covers1624.jdkutils.JavaInstall;
import net.covers1624.jdkutils.utils.JavaPropExtractor;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public class JVMUtils {
    private static final String JAVA_CLASS_PATH = "java.class.path";
    private static final String JAVA_BOOT_CLASS_PATH = "sun.boot.class.path";

    public static List<Path> getRuntimeJREClasspath() {
        List<Path> paths = JVMUtils.listSysProp(JAVA_BOOT_CLASS_PATH);
        if (paths == null) {
            String javaHomeProp = System.getProperty("java.home");
            if (javaHomeProp == null) {
                throw new IllegalStateException("Incompatible runtime: 'java.home' system property is missing.");
            }
            Path javaHome = Paths.get(javaHomeProp, new String[0]);
            paths = JVMUtils.listJMods(javaHome);
        }
        return paths;
    }

    public static JavaInstall getJavaInstall(Path executable) {
        JavaInstall install = JavaInstall.parse((Path)executable);
        if (install == null) {
            throw new RuntimeException("Unable to find valid Java installation at the provided Java executable.");
        }
        return install;
    }

    public static List<Path> getTargetJREClasspath(JavaInstall javaInstall) {
        Map props = JavaPropExtractor.extractProperties((Path)JavaInstall.getJavaExecutable((Path)javaInstall.javaHome, (boolean)true), Collections.singletonList(JAVA_BOOT_CLASS_PATH));
        if (props == null) {
            throw new RuntimeException("Failed to extract java classpath information.");
        }
        List<Path> paths = JVMUtils.listProp((String)props.get(JAVA_BOOT_CLASS_PATH));
        if (paths != null) {
            return paths;
        }
        return JVMUtils.listJMods(javaInstall.javaHome);
    }

    public static List<Path> getRuntimeClasspath() {
        List<Path> paths = JVMUtils.listSysProp(JAVA_CLASS_PATH);
        if (paths != null) {
            return paths;
        }
        return Collections.emptyList();
    }

    @Nullable
    private static List<Path> listSysProp(String sysProp) {
        return JVMUtils.listProp(System.getProperty(sysProp));
    }

    @Nullable
    private static List<Path> listProp(@Nullable String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        return FastStream.of((Object[])value.split(File.pathSeparator)).distinct().map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).toList();
    }

    private static List<Path> listJMods(Path javaHome) {
        List<Path> list;
        block10: {
            if (Files.notExists(javaHome, new LinkOption[0])) {
                throw new IllegalStateException("Incompatible runtime: 'java.home' system property resolves to non-existent path.");
            }
            Path jModFolder = javaHome.resolve("jmods");
            if (Files.notExists(jModFolder, new LinkOption[0])) {
                throw new IllegalStateException("Incompatible runtime: '${java.home}/jmods' does not exist.");
            }
            Stream<Path> files = Files.list(jModFolder);
            try {
                list = files.collect(Collectors.toList());
                if (files == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to list jmods directory.");
                }
            }
            files.close();
        }
        return list;
    }
}

