/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.matching;

import java.lang.runtime.SwitchBootstraps;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Return;
import net.covers1624.coffeegrinder.bytecode.insns.Throw;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import org.jetbrains.annotations.Nullable;

public class BranchLeaveMatching {
    @Nullable
    public static Return matchReturn(@Nullable Instruction insn) {
        if (!(insn instanceof Return)) {
            return null;
        }
        Return ret = (Return)insn;
        return ret;
    }

    @Nullable
    public static Return matchReturn(@Nullable Instruction insn, MethodDecl method) {
        if (!(insn instanceof Return)) {
            return null;
        }
        Return ret = (Return)insn;
        return ret.getMethod() == method ? ret : null;
    }

    @Nullable
    public static Leave matchLeave(@Nullable Instruction insn) {
        if (!(insn instanceof Leave)) {
            return null;
        }
        Leave leave = (Leave)insn;
        return leave;
    }

    @Nullable
    public static Leave matchLeave(@Nullable Instruction insn, BlockContainer container) {
        Leave leave = BranchLeaveMatching.matchLeave(insn);
        if (leave == null) {
            return null;
        }
        if (leave.getTargetContainer() != container) {
            return null;
        }
        return leave;
    }

    @Nullable
    public static Branch matchBranch(@Nullable Instruction insn) {
        if (!(insn instanceof Branch)) {
            return null;
        }
        Branch branch = (Branch)insn;
        return branch;
    }

    @Nullable
    public static Branch matchBranch(@Nullable Instruction insn, Block targetBlock) {
        Branch branch = BranchLeaveMatching.matchBranch(insn);
        if (branch == null) {
            return null;
        }
        if (branch.getTargetBlock() != targetBlock) {
            return null;
        }
        return branch;
    }

    public static boolean compatibleExitInstruction(@Nullable Instruction exit1, @Nullable Instruction exit2) {
        boolean bl;
        Instruction instruction = exit1;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Branch.class, Leave.class}, (Object)instruction, n)) {
                case 0: {
                    Branch br1 = (Branch)instruction;
                    if (!(exit2 instanceof Branch)) {
                        n = 1;
                        continue block4;
                    }
                    Branch br2 = (Branch)exit2;
                    if (br1.getTargetBlock() == br2.getTargetBlock()) {
                        bl = true;
                        break block4;
                    }
                    bl = false;
                    break block4;
                }
                case 1: {
                    Leave l1 = (Leave)instruction;
                    if (!(exit2 instanceof Leave)) {
                        n = 2;
                        continue block4;
                    }
                    Leave l2 = (Leave)exit2;
                    if (l1.getTargetContainer() == l2.getTargetContainer()) {
                        bl = true;
                        break block4;
                    }
                    bl = false;
                    break block4;
                }
                default: {
                    bl = false;
                    break block4;
                }
            }
            break;
        }
        return bl;
    }

    @Nullable
    public static Throw matchThrow(@Nullable Instruction insn) {
        if (!(insn instanceof Throw)) {
            return null;
        }
        Throw thr = (Throw)insn;
        return thr;
    }

    @Nullable
    public static Throw matchThrow(@Nullable Instruction insn, LocalVariable variable) {
        Throw thr = BranchLeaveMatching.matchThrow(insn);
        if (thr == null) {
            return null;
        }
        if (LoadStoreMatching.matchLoadLocal(thr.getArgument(), variable) == null) {
            return null;
        }
        return thr;
    }
}

