/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.matching;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.InvokeDynamic;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.New;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Method;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class InvokeMatching {
    @Nullable
    public static Invoke matchInvoke(@Nullable Instruction insn) {
        if (!(insn instanceof Invoke)) {
            return null;
        }
        Invoke invoke = (Invoke)insn;
        return invoke;
    }

    @Nullable
    public static Invoke matchInvoke(@Nullable Instruction insn, Invoke.InvokeKind kind) {
        Invoke invoke = InvokeMatching.matchInvoke(insn);
        if (invoke == null) {
            return null;
        }
        if (invoke.getKind() != kind) {
            return null;
        }
        return invoke;
    }

    @Nullable
    public static Invoke matchInvoke(@Nullable Instruction insn, Invoke.InvokeKind kind, Method method) {
        Invoke invoke = InvokeMatching.matchInvoke(insn, kind, method.getName(), method.getDescriptor());
        if (invoke == null) {
            return null;
        }
        if (!invoke.getMethod().equals(method)) {
            return null;
        }
        return invoke;
    }

    @Nullable
    public static Invoke matchInvoke(@Nullable Instruction insn, Invoke.InvokeKind kind, String name) {
        Invoke invoke = InvokeMatching.matchInvoke(insn, kind);
        if (invoke == null) {
            return null;
        }
        Method m = invoke.getMethod();
        if (!m.getName().equals(name)) {
            return null;
        }
        return invoke;
    }

    @Nullable
    public static Invoke matchInvoke(@Nullable Instruction insn, Invoke.InvokeKind kind, String name, Type desc) {
        Invoke invoke = InvokeMatching.matchInvoke(insn, kind, name);
        if (invoke == null) {
            return null;
        }
        Method m = invoke.getMethod();
        if (!m.getDescriptor().equals((Object)desc)) {
            return null;
        }
        return invoke;
    }

    @Nullable
    public static Invoke matchConstructorInvokeSpecial(@Nullable Instruction insn, ClassType decl) {
        Invoke invoke = InvokeMatching.matchInvoke(insn, Invoke.InvokeKind.SPECIAL);
        if (invoke == null) {
            return null;
        }
        Method method = invoke.getMethod().getDeclaration();
        if (!method.isConstructor()) {
            return null;
        }
        if (!method.getDeclaringClass().equals(decl)) {
            return null;
        }
        return invoke;
    }

    @Nullable
    public static Invoke getSuperConstructorCall(MethodDecl functionInsn) {
        if (!functionInsn.getMethod().isConstructor()) {
            return null;
        }
        ClassType superClass = functionInsn.getMethod().getDeclaringClass().getSuperClass().getDeclaration();
        Instruction instruction = functionInsn.getBody().getEntryPoint().getFirstChild();
        while (InvokeMatching.matchInvoke(instruction, Invoke.InvokeKind.SPECIAL, "<init>") == null) {
            if ((instruction = instruction.getNextSiblingOrNull()) != null) continue;
            return null;
        }
        return InvokeMatching.matchConstructorInvokeSpecial(instruction, superClass);
    }

    @Nullable
    public static New matchNew(@Nullable Instruction insn) {
        if (!(insn instanceof New)) {
            return null;
        }
        New newInsn = (New)insn;
        return newInsn;
    }

    @Nullable
    public static New matchNew(@Nullable Instruction insn, Method method) {
        New newInsn = InvokeMatching.matchNew(insn);
        if (newInsn == null) {
            return null;
        }
        if (!newInsn.getMethod().equals(method)) {
            return null;
        }
        return newInsn;
    }

    @Nullable
    public static New matchNew(@Nullable Instruction insn, ClassType type) {
        New newInsn = InvokeMatching.matchNew(insn);
        if (newInsn == null) {
            return null;
        }
        if (!newInsn.getResultType().equals(type)) {
            return null;
        }
        return newInsn;
    }

    @Nullable
    @Contract(value="null->null")
    public static InvokeDynamic matchInvokeDynamic(@Nullable Instruction insn) {
        if (!(insn instanceof InvokeDynamic)) {
            return null;
        }
        InvokeDynamic indy = (InvokeDynamic)insn;
        return indy;
    }

    @Nullable
    @Contract(value="null,_->null")
    public static InvokeDynamic matchInvokeDynamic(@Nullable Instruction insn, ClassType boostrapClass) {
        InvokeDynamic indy = InvokeMatching.matchInvokeDynamic(insn);
        if (indy == null) {
            return null;
        }
        if (!indy.bootstrapHandle.getDeclaringClass().getDeclaration().equals(boostrapClass)) {
            return null;
        }
        return indy;
    }

    @Nullable
    @Contract(value="null,_,_->null")
    public static InvokeDynamic matchInvokeDynamic(@Nullable Instruction insn, ClassType boostrapClass, String boostrapMethod) {
        InvokeDynamic indy = InvokeMatching.matchInvokeDynamic(insn, boostrapClass);
        if (indy == null) {
            return null;
        }
        if (!indy.bootstrapHandle.getName().equals(boostrapMethod)) {
            return null;
        }
        return indy;
    }
}

