package net.covers1624.coffeegrinder.bytecode;

import java.util.ArrayList;
import java.util.List;

/**
 * An Indexed {@link InstructionCollection}.
 * <p>
 * Once set, this collection has an immutable length and does
 * not support, removing, adding, or inserting Instructions.
 * <p>
 * Created by covers1624 on 27/11/21.
 */
public class IndexedInstructionCollection<T extends Instruction> extends InstructionCollection<T> {

    private final List<IndexedCollectionSlot> slots = new ArrayList<>();

    public IndexedInstructionCollection(Instruction parent) {
        super(parent);
    }

    /**
     * Sets the {@link Instruction}s contained within this slot.
     * <p>
     * This may only be called once.
     *
     * @param values The {@link Instruction} values.
     */
    public void setValues(Iterable<T> values) {
        if (head != null) throw new UnsupportedOperationException("Cannot replace insn list.");

        int i = 0;
        for (T value : values) {
            IndexedCollectionSlot slot = new IndexedCollectionSlot(parent, i++);
            add(value, slot);
            slots.add(slot);
        }
    }

    public T get(int index) {
        return slots.get(index).get();
    }

    @Override
    public void add(T value) {
        throw new UnsupportedOperationException("IndexedInstructionCollection is length immutable.");
    }

    @Override
    public void addAll(Iterable<? extends T> values) {
        throw new UnsupportedOperationException("IndexedInstructionCollection is length immutable.");
    }

    private class IndexedCollectionSlot extends CollectionSlot {

        private final int index;

        public IndexedCollectionSlot(Instruction parent, int index) {
            super(parent);
            this.index = index;
        }

        @Override
        void remove() {
            removeValue();
        }

        @Override
        void insertBefore(Instruction value) {
            throw new UnsupportedOperationException("IndexedInstructionCollection is length immutable.");
        }

        @Override
        void insertAfter(Instruction value) {
            throw new UnsupportedOperationException("IndexedInstructionCollection is length immutable.");
        }
    }
}
