package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.IntegerConstantType;
import net.covers1624.coffeegrinder.type.PrimitiveType;

/**
 * Created by covers1624 on 6/10/22.
 */
public final class LdcNumber extends LdcInsn {

    private final Number value;
    private final AType resultType;

    public LdcNumber(Number value) {
        this.value = value;
        resultType = switch (value) {
            case Double v -> PrimitiveType.DOUBLE;
            case Float v -> PrimitiveType.FLOAT;
            case Integer i -> new IntegerConstantType(i);
            case Long l -> PrimitiveType.LONG;
            default -> throw new IllegalArgumentException("Unknown LdcNumber value: " + value.getClass());
        };
    }

    @Override
    public AType getResultType() {
        return resultType;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitLdcNumber(this, ctx);
    }

    @Override
    public Instruction copy() {
        return new LdcNumber(value);
    }

    @Override
    public Number getRawValue() {
        return value;
    }

    public Number getValue() {
        return value;
    }

    public int intValue() {
        assert value instanceof Integer;
        return value.intValue();
    }
}
