package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Leave;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

/**
 * Created by covers1624 on 2/10/21.
 */
public class TransformerUtils {

    public static void moveBlocksIntoContainer(Iterable<Block> blocks, BlockContainer fromContainer, BlockContainer toContainer, @Nullable Block exitBlock) {
        // Move other blocks into the switch body: they're all dominated by the switch head,
        // and thus cannot be the target of branch instructions outside the switch.
        for (Block block : blocks) {
            // some blocks might already be in use by nested switches that were detected earlier;
            // don't move those (they'll be implicitly moved when the block containing the
            // nested switch container is moved).
            BlockContainer parent = (BlockContainer) block.getParentOrNull();
            if (parent == null || parent == fromContainer) {
                Block target = toContainer.blocks.filter(e -> e.getBytecodeOffset() < block.getBytecodeOffset()).lastOrDefault();
                if (target != null) {
                    // Try to put the block in order.
                    target.insertAfter(block);
                } else {
                    toContainer.blocks.add(block);
                }
            } else {
                assert parent.isDescendantOf(fromContainer);
            }
        }

        if (exitBlock == null) return;

        exitBlock.getBranches()
                .filter(e -> e.isDescendantOf(toContainer))
                .toLinkedList()
                .forEach(e -> e.replaceWith(new Leave(toContainer).withOffsets(e)));
    }
}
