/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.matching;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.ArrayElementReference;
import net.covers1624.coffeegrinder.bytecode.insns.ArrayLen;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.type.Field;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class LoadStoreMatching {
    @Nullable
    public static Load matchLoad(@Nullable Instruction insn) {
        if (!(insn instanceof Load)) {
            return null;
        }
        Load l = (Load)insn;
        return l;
    }

    @Nullable
    public static Store matchStore(@Nullable Instruction insn) {
        if (!(insn instanceof Store)) {
            return null;
        }
        Store s = (Store)insn;
        return s;
    }

    @Nullable
    public static Store matchStoreLocalLoadLocal(@Nullable Instruction insn, LocalVariable variable) {
        Store store = LoadStoreMatching.matchStoreLocal(insn);
        if (store == null) {
            return null;
        }
        Load load = LoadStoreMatching.matchLoadLocal(store.getValue(), variable);
        if (load == null) {
            return null;
        }
        return store;
    }

    @Nullable
    public static LocalReference matchLocalRef(@Nullable Instruction insn) {
        if (!(insn instanceof LocalReference)) {
            return null;
        }
        LocalReference r = (LocalReference)insn;
        return r;
    }

    @Nullable
    public static LocalReference matchLocalRef(@Nullable Instruction insn, LocalVariable variable) {
        LocalReference localRef = LoadStoreMatching.matchLocalRef(insn);
        if (localRef == null || localRef.variable != variable) {
            return null;
        }
        return localRef;
    }

    @Nullable
    @Contract(value="null->null")
    public static Load matchLoadLocal(@Nullable Instruction insn) {
        Load load = LoadStoreMatching.matchLoad(insn);
        if (load == null || !(load.getReference() instanceof LocalReference)) {
            return null;
        }
        return load;
    }

    @Nullable
    public static Load matchLoadLocal(@Nullable Instruction insn, LocalVariable variable) {
        Load load = LoadStoreMatching.matchLoadLocal(insn);
        if (load == null) {
            return null;
        }
        if (load.getVariable() != variable) {
            return null;
        }
        return load;
    }

    @Nullable
    public static Store matchStoreLocal(@Nullable Instruction insn) {
        Store store = LoadStoreMatching.matchStore(insn);
        if (store == null || !(store.getReference() instanceof LocalReference)) {
            return null;
        }
        return store;
    }

    @Nullable
    public static Store matchStoreLocal(@Nullable Instruction insn, LocalVariable variable) {
        Store store = LoadStoreMatching.matchStoreLocal(insn);
        if (store == null) {
            return null;
        }
        if (store.getVariable() != variable) {
            return null;
        }
        return store;
    }

    @Nullable
    public static FieldReference matchFieldRef(@Nullable Instruction insn) {
        if (!(insn instanceof FieldReference)) {
            return null;
        }
        FieldReference r = (FieldReference)insn;
        return r;
    }

    @Nullable
    public static FieldReference matchFieldRef(@Nullable Instruction insn, Field field) {
        FieldReference fieldRef = LoadStoreMatching.matchFieldRef(insn);
        if (fieldRef == null) {
            return null;
        }
        if (!LoadStoreMatching.matchField(fieldRef.getField(), field)) {
            return null;
        }
        return fieldRef;
    }

    @Nullable
    public static Load matchLoadField(@Nullable Instruction insn) {
        Load load = LoadStoreMatching.matchLoad(insn);
        if (load == null) {
            return null;
        }
        if (!(load.getReference() instanceof FieldReference)) {
            return null;
        }
        return load;
    }

    @Nullable
    public static Load matchLoadField(@Nullable Instruction insn, Field field) {
        Load load = LoadStoreMatching.matchLoad(insn);
        if (load == null) {
            return null;
        }
        if (LoadStoreMatching.matchFieldRef(load.getReference(), field) == null) {
            return null;
        }
        return load;
    }

    @Nullable
    public static FieldReference matchLoadFieldRef(@Nullable Instruction insn) {
        Load load = LoadStoreMatching.matchLoad(insn);
        if (load == null) {
            return null;
        }
        return LoadStoreMatching.matchFieldRef(load.getReference());
    }

    @Nullable
    public static FieldReference matchStoreFieldRef(@Nullable Instruction insn) {
        Store store = LoadStoreMatching.matchStore(insn);
        if (store == null) {
            return null;
        }
        return LoadStoreMatching.matchFieldRef(store.getReference());
    }

    @Nullable
    public static Store matchStoreField(@Nullable Instruction insn) {
        Store store = LoadStoreMatching.matchStore(insn);
        if (store == null || !(store.getReference() instanceof FieldReference)) {
            return null;
        }
        return store;
    }

    @Nullable
    @Contract(value="null,_->null")
    public static Store matchStoreField(@Nullable Instruction insn, Field field) {
        Store store = LoadStoreMatching.matchStore(insn);
        if (store == null) {
            return null;
        }
        if (LoadStoreMatching.matchFieldRef(store.getReference(), field) == null) {
            return null;
        }
        return store;
    }

    public static boolean matchField(Field field1, Field field2) {
        return field1.getName().equals(field2.getName()) && field1.getDescriptor().equals((Object)field2.getDescriptor()) && (field1.getDeclaringClass().equals(field2.getDeclaringClass()) || field1.equals(field2));
    }

    public static boolean equivalentFieldDescriptors(Field field1, Field field2) {
        return field1.getName().equals(field2.getName()) && field1.getDescriptor().equals((Object)field2.getDescriptor()) && field1.getDeclaringClass().equals(field2.getDeclaringClass());
    }

    @Nullable
    public static ArrayLen matchArrayLen(@Nullable Instruction insn) {
        if (!(insn instanceof ArrayLen)) {
            return null;
        }
        ArrayLen r = (ArrayLen)insn;
        return r;
    }

    @Nullable
    public static ArrayLen matchArrayLenLoad(@Nullable Instruction insn, LocalVariable loadVar) {
        ArrayLen arrayLen = LoadStoreMatching.matchArrayLen(insn);
        if (arrayLen == null) {
            return null;
        }
        Load load = LoadStoreMatching.matchLoadLocal(arrayLen.getArray(), loadVar);
        if (load == null) {
            return null;
        }
        return arrayLen;
    }

    @Nullable
    public static ArrayElementReference matchElemRef(@Nullable Instruction insn) {
        if (!(insn instanceof ArrayElementReference)) {
            return null;
        }
        ArrayElementReference r = (ArrayElementReference)insn;
        return r;
    }

    @Nullable
    public static ArrayElementReference matchLoadElemRef(@Nullable Instruction insn) {
        Load load = LoadStoreMatching.matchLoad(insn);
        if (load == null) {
            return null;
        }
        return LoadStoreMatching.matchElemRef(load.getReference());
    }
}

