/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.net;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Date;
import java.util.Objects;
import net.covers1624.quack.annotation.Requires;
import net.covers1624.quack.io.IOUtils;
import net.covers1624.quack.io.ProgressInputStream;
import net.covers1624.quack.net.AbstractDownloadAction;
import net.covers1624.quack.net.DownloadAction;
import net.covers1624.quack.net.download.DownloadListener;
import net.covers1624.quack.net.httpapi.EngineRequest;
import net.covers1624.quack.net.httpapi.EngineResponse;
import net.covers1624.quack.net.httpapi.HttpEngine;
import net.covers1624.quack.net.httpapi.WebBody;
import net.covers1624.quack.util.TimeUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requires(value="org.slf4j:slf4j-api")
public class HttpEngineDownloadAction
extends AbstractDownloadAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpEngineDownloadAction.class);
    @Nullable
    private HttpEngine engine;

    public HttpEngineDownloadAction() {
    }

    public HttpEngineDownloadAction(HttpEngine engine) {
        this.engine = engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws IOException {
        HttpEngine engine = Objects.requireNonNull(this.engine, "HttpEngine not set.");
        String url = Objects.requireNonNull(this.url, "URL not set");
        DownloadAction.Dest dest = Objects.requireNonNull(this.dest, "Dest not set");
        EngineRequest request = engine.newRequest().method("GET", null).url(url).headers(this.headerList);
        if (this.userAgent != null && !this.headerList.contains("User-Agent")) {
            request.header("User-Agent", this.userAgent);
        }
        String eTag = dest.getEtag();
        if (this.useETag && eTag != null) {
            request.header("If-None-Match", eTag.trim());
        }
        long lastModifiedDisk = dest.getLastModified();
        if (this.onlyIfModified && lastModifiedDisk != -1L) {
            request.header("If-Modified-Since", TimeUtils.FORMAT_RFC1123.format(new Date(lastModifiedDisk)));
        }
        if (this.downloadListener != null) {
            this.downloadListener.connecting();
        }
        if (!this.quiet) {
            LOGGER.info("Connecting to {}.", (Object)url);
        }
        try (EngineResponse response = request.execute();){
            int code = response.statusCode();
            this.validateCode(code, response.message());
            String lastModifiedHeader = response.headers().get("Last-Modified");
            Date lastModifiedHeaderDate = null;
            if (lastModifiedHeader != null) {
                lastModifiedHeaderDate = TimeUtils.parseDate(lastModifiedHeader);
            }
            this.upToDate = this.calcUpToDate(code, lastModifiedDisk, lastModifiedHeaderDate);
            if (this.upToDate) {
                return;
            }
            WebBody body = response.body();
            if (body == null) {
                return;
            }
            long contentLen = body.length();
            if (this.downloadListener != null) {
                this.downloadListener.start(contentLen);
            }
            InputStream content = body.open();
            if (this.downloadListener != null) {
                content = new ProgressInputStream(content, this.downloadListener);
            }
            if (!this.quiet) {
                LOGGER.info("Downloading '{}'.", (Object)url);
            }
            boolean success = false;
            try (InputStream is = content;
                 OutputStream os = dest.getOutputStream();){
                IOUtils.copy(is, os);
                success = true;
            }
            finally {
                if (!this.quiet) {
                    LOGGER.info("Finished '{}'. Success? {}", (Object)url, (Object)success);
                }
                dest.onFinished(success);
            }
            if (this.onlyIfModified && lastModifiedHeaderDate != null) {
                dest.setLastModified(lastModifiedHeaderDate.getTime());
            }
            String eTagHeader = response.headers().get("ETag");
            if (this.useETag && eTagHeader != null) {
                dest.setEtag(eTagHeader);
            }
        }
    }

    public HttpEngineDownloadAction setEngine(HttpEngine engine) {
        this.engine = engine;
        return this;
    }

    @Override
    public HttpEngineDownloadAction setUrl(String url) {
        super.setUrl(url);
        return this;
    }

    @Override
    public HttpEngineDownloadAction setDest(DownloadAction.Dest dest) {
        super.setDest(dest);
        return this;
    }

    @Override
    public HttpEngineDownloadAction setDest(StringWriter sw) {
        super.setDest(sw);
        return this;
    }

    @Override
    public HttpEngineDownloadAction setDest(OutputStream os) {
        super.setDest(os);
        return this;
    }

    @Override
    public HttpEngineDownloadAction setDest(File file) {
        super.setDest(file);
        return this;
    }

    @Override
    public HttpEngineDownloadAction setDest(Path path) {
        super.setDest(path);
        return this;
    }

    @Override
    public HttpEngineDownloadAction setOnlyIfModified(boolean onlyIfModified) {
        super.setOnlyIfModified(onlyIfModified);
        return this;
    }

    @Override
    public HttpEngineDownloadAction setUseETag(boolean useETag) {
        super.setUseETag(useETag);
        return this;
    }

    @Override
    public HttpEngineDownloadAction setQuiet(boolean quiet) {
        super.setQuiet(quiet);
        return this;
    }

    @Override
    public HttpEngineDownloadAction addRequestHeader(String key, String value) {
        super.addRequestHeader(key, value);
        return this;
    }

    @Override
    public HttpEngineDownloadAction setUserAgent(String userAgent) {
        super.setUserAgent(userAgent);
        return this;
    }

    @Override
    public HttpEngineDownloadAction setDownloadListener(DownloadListener downloadListener) {
        super.setDownloadListener(downloadListener);
        return this;
    }
}

