/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers.statement;

import java.util.LinkedList;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.ArrayElementReference;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNumber;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.NewArray;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.matching.LdcMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public class ArrayInitializers
implements StatementTransformer {
    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        Store store = LoadStoreMatching.matchStoreLocal(statement);
        if (store == null || store.getVariable().getKind() != LocalVariable.VariableKind.STACK_SLOT) {
            return;
        }
        Instruction insn = store.getValue();
        if (!(insn instanceof NewArray)) {
            return;
        }
        NewArray newArray = (NewArray)insn;
        if (newArray.isInitializer || newArray.getIndices().size() != 1) {
            return;
        }
        LdcNumber ldc = LdcMatching.matchLdcInt((Instruction)newArray.getIndices().first());
        if (ldc == null) {
            return;
        }
        int numElements = ldc.intValue();
        LinkedList<Store> elements = new LinkedList<Store>();
        Instruction pointer = store.getNextSiblingOrNull();
        for (int i = 0; i < numElements; ++i) {
            if (pointer == null) {
                return;
            }
            Store element = this.getStoreElement(pointer, store.getVariable(), i);
            if (element == null) {
                return;
            }
            elements.add(element);
            pointer = pointer.getNextSiblingOrNull();
        }
        ctx.pushStep("Create array initializer");
        ctx.requestRerun();
        newArray.replaceWith(new NewArray(newArray.getType(), true, (Iterable<Instruction>)FastStream.of(elements).map(Store::getValue)));
        elements.forEach(Instruction::remove);
        ctx.popStep();
    }

    @Nullable
    private Store getStoreElement(Instruction insn, LocalVariable arrayVar, int index) {
        Store store = LoadStoreMatching.matchStore(insn);
        if (store == null) {
            return null;
        }
        ArrayElementReference elemRef = LoadStoreMatching.matchElemRef(store.getReference());
        if (elemRef == null) {
            return null;
        }
        if (LoadStoreMatching.matchLoadLocal(elemRef.getArray(), arrayVar) == null) {
            return null;
        }
        if (LdcMatching.matchLdcInt(elemRef.getIndex(), index) == null) {
            return null;
        }
        return store;
    }
}

