/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.util.asm;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.covers1624.coffeegrinder.util.asm.LabelRange;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.ModuleVisitor;
import org.objectweb.asm.RecordComponentVisitor;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceAnnotationVisitor;
import org.objectweb.asm.util.TraceFieldVisitor;
import org.objectweb.asm.util.TraceMethodVisitor;
import org.objectweb.asm.util.TraceModuleVisitor;
import org.objectweb.asm.util.TraceRecordComponentVisitor;

public class OrderedTextifier {
    public static void main(String[] args) throws IOException {
        Path path = Paths.get(String.join((CharSequence)" ", args), new String[0]);
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);){
            ClassReader reader = new ClassReader(is);
            ClassNode cNode = new ClassNode();
            reader.accept((ClassVisitor)cNode, 0);
            System.out.println(OrderedTextifier.textify(cNode));
        }
    }

    public static String textify(ClassNode cNode) {
        LabelSettingTextifier textifier = new LabelSettingTextifier();
        cNode.accept((ClassVisitor)new CustomTraceClassVisitor(cNode, textifier));
        return OrderedTextifier.toString(textifier);
    }

    public static String textify(MethodNode mNode) {
        LabelSettingTextifier textifier = new LabelSettingTextifier();
        textifier.setLabels(OrderedTextifier.extractLabels(mNode));
        mNode.accept((MethodVisitor)new TraceMethodVisitor((Printer)textifier.visitMethod(mNode.access, mNode.name, mNode.desc, mNode.signature, mNode.exceptions == null ? null : mNode.exceptions.toArray(new String[0]))));
        return OrderedTextifier.toString(textifier);
    }

    private static String toString(Textifier textifier) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        textifier.print(printWriter);
        printWriter.flush();
        return stringWriter.toString();
    }

    private static List<Label> extractLabels(MethodNode mNode) {
        if (mNode.instructions.size() == 0) {
            return List.of();
        }
        LabelRange range = LabelRange.extractRange(mNode.instructions);
        if (range == null) {
            return Collections.emptyList();
        }
        return range.range;
    }

    private static class LabelSettingTextifier
    extends Textifier {
        public LabelSettingTextifier() {
            super(589824);
        }

        protected Textifier createTextifier() {
            return new LabelSettingTextifier();
        }

        public void setLabels(List<Label> labels) {
            this.labelNames = new HashMap();
            for (Label label : labels) {
                this.labelNames.put(label, "L" + this.labelNames.size());
            }
        }
    }

    private static class CustomTraceClassVisitor
    extends ClassVisitor {
        private final Map<String, List<Label>> labels;
        private final Textifier t;

        private CustomTraceClassVisitor(ClassNode cNode, Textifier t) {
            super(589824);
            this.t = t;
            ImmutableMap.Builder labelsBuilder = ImmutableMap.builder();
            for (MethodNode method : cNode.methods) {
                labelsBuilder.put((Object)(method.name + method.desc), OrderedTextifier.extractLabels(method));
            }
            this.labels = labelsBuilder.build();
        }

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            LabelSettingTextifier textifier = (LabelSettingTextifier)this.t.visitMethod(access, name, descriptor, signature, exceptions);
            textifier.setLabels(this.labels.get(name + descriptor));
            return new TraceMethodVisitor((Printer)textifier);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.t.visit(version, access, name, signature, superName, interfaces);
        }

        public void visitSource(String source, String debug) {
            this.t.visitSource(source, debug);
        }

        public ModuleVisitor visitModule(String name, int access, String version) {
            return new TraceModuleVisitor(this.t.visitModule(name, access, version));
        }

        public void visitNestHost(String nestHost) {
            this.t.visitNestHost(nestHost);
        }

        public void visitOuterClass(String owner, String name, String descriptor) {
            this.t.visitOuterClass(owner, name, descriptor);
        }

        public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
            return new TraceAnnotationVisitor((Printer)this.t.visitClassAnnotation(descriptor, visible));
        }

        public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
            return new TraceAnnotationVisitor(this.t.visitClassTypeAnnotation(typeRef, typePath, descriptor, visible));
        }

        public void visitAttribute(Attribute attribute) {
            this.t.visitClassAttribute(attribute);
        }

        public void visitNestMember(String nestMember) {
            this.t.visitNestMember(nestMember);
        }

        public void visitPermittedSubclass(String permittedSubclass) {
            this.t.visitPermittedSubclass(permittedSubclass);
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            this.t.visitInnerClass(name, outerName, innerName, access);
        }

        public RecordComponentVisitor visitRecordComponent(String name, String descriptor, String signature) {
            return new TraceRecordComponentVisitor(this.t.visitRecordComponent(name, descriptor, signature));
        }

        public FieldVisitor visitField(int access, String name, String descriptor, String signature, Object value) {
            return new TraceFieldVisitor((Printer)this.t.visitField(access, name, descriptor, signature, value));
        }

        public void visitEnd() {
            this.t.visitClassEnd();
        }
    }
}

