package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 7/12/21.
 */
public abstract class Reference extends Instruction {

    private boolean isReadFrom;
    private boolean isWrittenTo;

    @Override
    public final AType getResultType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public Reference copy() {
        return (Reference) super.copy();
    }

    @Override
    protected void onDisconnected() {
        super.onDisconnected();
        isReadFrom = false;
        isWrittenTo = false;
    }

    public abstract AType getType();

    //@formatter:off
    public boolean isReadFrom() { return isReadFrom; }
    public boolean isWrittenTo() { return isWrittenTo; }
    void setReadFrom(boolean readFrom) { isReadFrom = readFrom; }
    void setWrittenTo(boolean writtenTo) { isWrittenTo = writtenTo; }
    //@formatter:on
}
