/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type.asm;

import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.ITypeParameterizedMember;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.type.asm.AsmTypeParameter;
import net.covers1624.coffeegrinder.type.asm.ReferenceTypeSignatureParser;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.signature.SignatureVisitor;

public abstract class SignatureParser
extends SignatureVisitor {
    protected final TypeResolver typeResolver;
    protected final ITypeParameterizedMember scope;
    private int currParamIndex;
    @Nullable
    private AsmTypeParameter currentTypeParameter;

    protected SignatureParser(TypeResolver typeResolver, ITypeParameterizedMember scope) {
        super(589824);
        this.typeResolver = typeResolver;
        this.scope = scope;
    }

    public void visitFormalTypeParameter(String name) {
        this.currentTypeParameter = (AsmTypeParameter)this.scope.getTypeParameters().get(this.currParamIndex++);
        assert (this.currentTypeParameter.getName().equals(name));
    }

    public SignatureVisitor visitClassBound() {
        return new ReferenceTypeSignatureParser(this.typeResolver, this.scope){

            @Override
            public void endType(AType type) {
                assert (SignatureParser.this.currentTypeParameter != null);
                SignatureParser.this.currentTypeParameter.upperBound = (ReferenceType)type;
            }
        };
    }

    public SignatureVisitor visitInterfaceBound() {
        assert (this.currentTypeParameter != null);
        final ReferenceType baseType = this.currentTypeParameter.upperBound;
        if (baseType == null) {
            this.currentTypeParameter.upperBound = this.typeResolver.resolveClass(TypeResolver.OBJECT_TYPE);
        }
        return new ReferenceTypeSignatureParser(this.typeResolver, this.scope){

            @Override
            public void endType(AType type) {
                SignatureParser.this.currentTypeParameter.upperBound = baseType == null ? (ClassType)type : TypeSystem.intersection(baseType, (ClassType)type);
            }
        };
    }

    public SignatureVisitor visitParameterType() {
        throw new IllegalStateException();
    }

    public SignatureVisitor visitReturnType() {
        throw new IllegalStateException();
    }

    public SignatureVisitor visitExceptionType() {
        throw new IllegalStateException();
    }

    public void visitBaseType(char descriptor) {
        throw new IllegalStateException();
    }

    public void visitTypeVariable(String name) {
        throw new IllegalStateException();
    }

    public SignatureVisitor visitArrayType() {
        throw new IllegalStateException();
    }

    public void visitClassType(String name) {
        throw new IllegalStateException();
    }

    public void visitInnerClassType(String name) {
        throw new IllegalStateException();
    }

    public void visitTypeArgument() {
        throw new IllegalStateException();
    }

    public SignatureVisitor visitTypeArgument(char wildcard) {
        throw new IllegalStateException();
    }

    public void visitEnd() {
        throw new IllegalStateException();
    }
}

