/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.insns.Unary;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public final class Cast
extends Unary {
    private AType type;

    public Cast(Instruction argument, AType type) {
        super(argument);
        this.type = type;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return this.type instanceof PrimitiveType ? InstructionFlag.NONE : InstructionFlag.MAY_THROW.toSet();
    }

    @Override
    public AType getResultType() {
        return this.type;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitCheckCast(this, ctx);
    }

    @Override
    public Instruction copy() {
        return new Cast(this.getArgument().copy(), this.type);
    }

    public AType getType() {
        return this.type;
    }

    public void setType(AType type) {
        this.type = type;
        this.invalidateFlags();
    }
}

