/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.Iterator;
import java.util.LinkedList;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.Switch;
import net.covers1624.coffeegrinder.bytecode.insns.SwitchTable;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;

public class SwitchInlining
implements MethodTransformer {
    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        LinkedList<Switch> switches = function.descendantsToList(Switch.class);
        for (Switch aSwitch : switches) {
            BlockContainer switchContainer = aSwitch.getBody();
            ctx.pushStep("Inline switch sections " + switchContainer.getEntryPoint().getName());
            Iterator<SwitchTable.SwitchSection> iterator = aSwitch.getSwitchTable().sections.iterator();
            while (iterator.hasNext()) {
                Object object;
                SwitchTable.SwitchSection section = iterator.next();
                SwitchTable.SwitchSection nextSibling = (SwitchTable.SwitchSection)section.getNextSiblingOrNull();
                Instruction instruction = section.getBody();
                if (!(instruction instanceof Branch)) {
                    if (section.values.size() != 1 || !(section.values.first() instanceof Nop) || BranchLeaveMatching.matchLeave(section.getBody(), switchContainer) == null) continue;
                    ctx.pushStep("Remove redundant default case");
                    section.remove();
                    ctx.popStep();
                    continue;
                }
                Branch branch = (Branch)instruction;
                Block target = branch.getTargetBlock();
                if (target.getIncomingEdgeCount() != 1) continue;
                branch.replaceWith(target);
                if (nextSibling == null || !((object = target.instructions.last()) instanceof Branch)) continue;
                Branch lastBranch = (Branch)object;
                if (BranchLeaveMatching.matchBranch(nextSibling.getBody(), lastBranch.getTargetBlock()) == null) continue;
                lastBranch.remove();
            }
            ctx.popStep();
        }
    }
}

