/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.MonitorEnter;
import net.covers1624.coffeegrinder.bytecode.insns.MonitorExit;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.Synchronized;
import net.covers1624.coffeegrinder.bytecode.insns.TryFinally;
import net.covers1624.coffeegrinder.bytecode.matching.BranchLeaveMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;
import net.covers1624.coffeegrinder.util.None;

public class SynchronizedTransform
extends SimpleInsnVisitor<MethodTransformContext>
implements MethodTransformer {
    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        function.accept(this, ctx);
    }

    @Override
    public None visitTryFinally(TryFinally tryFinally, MethodTransformContext ctx) {
        Instruction instruction = tryFinally.getPrevSiblingOrNull();
        if (!(instruction instanceof MonitorEnter)) {
            return (None)super.visitTryFinally(tryFinally, ctx);
        }
        MonitorEnter monitor = (MonitorEnter)instruction;
        ctx.pushStep("Generate Synchronized");
        Store store = (Store)monitor.getArgument();
        Block finallyBody = tryFinally.getFinallyBody().getEntryPoint();
        MonitorExit monitorExit = (MonitorExit)finallyBody.getFirstChild();
        Objects.requireNonNull(LoadStoreMatching.matchLoadLocal(monitorExit.getArgument(), store.getVariable()));
        Objects.requireNonNull(BranchLeaveMatching.matchLeave(monitorExit.getNextSibling(), tryFinally.getFinallyBody()));
        Synchronized sync = tryFinally.replaceWith((Synchronized)new Synchronized(store.getValue(), tryFinally.getTryBody()).withOffsets(tryFinally));
        assert (store.getVariable().getLoadCount() == 0);
        monitor.remove();
        ctx.popStep();
        sync.accept(this, ctx);
        return NONE;
    }
}

