/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.testengine.testcase.util;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.covers1624.coffeegrinder.testengine.testcase.TestCase;
import net.covers1624.coffeegrinder.testengine.testcase.util.PathHelper;
import net.covers1624.quack.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public final class InputPath
extends PathHelper
implements Closeable {
    private final Path root;
    @Nullable
    private final Closeable closeable;
    private final boolean hasInners;

    private InputPath(Path root, @Nullable Closeable closeable, String extension, boolean hasInners) {
        super(extension);
        this.root = root;
        this.closeable = closeable;
        this.hasInners = hasInners;
    }

    public static InputPath of(Path root, String extension, boolean hasInners) {
        Path realRoot;
        FileSystem closeable = null;
        if (Files.isDirectory(root, new LinkOption[0])) {
            realRoot = root;
        } else if (InputPath.isJarOrZip(root)) {
            try {
                FileSystem fs = IOUtils.getJarFileSystem((Path)root, (boolean)false);
                realRoot = fs.getPath("/", new String[0]);
                closeable = fs;
            }
            catch (IOException ex) {
                throw new RuntimeException("Unable to open jar/zip: " + String.valueOf(root), ex);
            }
        } else {
            throw new IllegalArgumentException("Unknown root file: " + String.valueOf(root));
        }
        return new InputPath(realRoot, closeable, extension, hasInners);
    }

    public Path getPathFor(TestCase clazz) {
        return this.getPathFor(clazz.className);
    }

    public Path getPathFor(String cName) {
        String name = this.nameFor(cName);
        return this.getRoot().resolve(name);
    }

    public Path getRoot() {
        return this.root;
    }

    public List<Path> findInners(TestCase clazz) {
        return this.findInners(clazz.className);
    }

    public List<Path> findInners(String cName) {
        List<Path> list;
        block9: {
            if (!this.hasInners) {
                throw new UnsupportedOperationException("InputPath does not have inners.");
            }
            Path path = this.getPathFor(cName);
            String prefix = path.getFileName().toString().replace(".class", "") + "$";
            Stream<Path> files = Files.list(path.getParent());
            try {
                list = files.filter(e -> e.getFileName().toString().startsWith(prefix)).collect(Collectors.toList());
                if (files == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    throw new IllegalArgumentException("Unable to find inner class sibling files for " + String.valueOf(path));
                }
            }
            files.close();
        }
        return list;
    }

    public boolean exists(String cName) {
        return Files.exists(this.root.resolve(cName.replace('.', '/') + "." + this.extension), new LinkOption[0]);
    }

    public List<Path> allFiles() {
        LinkedList<Path> paths = new LinkedList<Path>();
        try (Stream<Path> stream = Files.walk(this.root, new FileVisitOption[0]);){
            stream.filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(paths::add);
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to list all paths in root: " + String.valueOf(this.root));
        }
        return paths;
    }

    private static boolean isJarOrZip(Path path) {
        String fName = path.getFileName().toString();
        return fName.endsWith(".jar") || fName.endsWith(".zip");
    }

    @Override
    public void close() {
        if (this.closeable != null) {
            try {
                this.closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

