/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.Binary;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.CompoundAssignment;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.matching.AssignmentMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.AssignmentExpressions;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.util.None;

public class CompoundAssignments
extends SimpleInsnVisitor<MethodTransformContext>
implements StatementTransformer,
MethodTransformer {
    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        statement.accept(this, ctx);
    }

    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        function.accept(this, ctx);
    }

    @Override
    public None visitStore(Store store, MethodTransformContext ctx) {
        if (this.transformCompoundAssignment(store, ctx)) {
            return NONE;
        }
        return (None)super.visitStore(store, ctx);
    }

    public boolean transformCompoundAssignment(Store store, MethodTransformContext ctx) {
        Instruction instruction;
        Binary binary = AssignmentMatching.matchStoreArgBinaryWithPossibleCast(store);
        if (binary == null) {
            return false;
        }
        if (TypeSystem.isString(binary.getResultType())) {
            Binary left;
            while ((instruction = binary.getLeft()) instanceof Binary && TypeSystem.isString((left = (Binary)instruction).getResultType())) {
                binary = left;
            }
        }
        if (!((instruction = binary.getLeft()) instanceof Load)) {
            return false;
        }
        Load numericLoad = (Load)instruction;
        if (!AssignmentExpressions.equivalentRefs(store.getReference(), numericLoad.getReference())) {
            return false;
        }
        ctx.pushStep("Create compound assignment");
        if (store.getValue() instanceof Cast) {
            store.getValue().replaceWith(binary);
        }
        binary.replaceWith(binary.getRight());
        CompoundAssignment repl = new CompoundAssignment(binary.getOp(), store.getReference(), store.getValue());
        store.replaceWith(repl.withOffsets(store));
        ctx.popStep();
        return true;
    }
}

