/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type.asm;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ITypeParameterizedMember;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.asm.ReferenceTypeSignatureParser;
import net.covers1624.coffeegrinder.type.asm.SignatureParser;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class MethodSignatureParser
extends SignatureParser {
    @Nullable
    private AType returnType;
    private final ImmutableList.Builder<AType> parameters = ImmutableList.builder();
    private final ImmutableList.Builder<ReferenceType> exceptions = ImmutableList.builder();

    private MethodSignatureParser(TypeResolver typeResolver, ITypeParameterizedMember scope) {
        super(typeResolver, scope);
    }

    public static MethodSignatureParser parse(TypeResolver typeResolver, ITypeParameterizedMember scope, String signature) {
        MethodSignatureParser parser = new MethodSignatureParser(typeResolver, scope);
        new SignatureReader(signature).accept((SignatureVisitor)parser);
        return parser;
    }

    public AType getReturnType() {
        return Objects.requireNonNull(this.returnType);
    }

    public List<AType> getParameters() {
        return this.parameters.build();
    }

    public List<ReferenceType> getExceptions() {
        return this.exceptions.build();
    }

    @Override
    public SignatureVisitor visitParameterType() {
        return new ReferenceTypeSignatureParser(this.typeResolver, this.scope){

            @Override
            public void endType(AType type) {
                MethodSignatureParser.this.parameters.add((Object)type);
            }
        };
    }

    @Override
    public SignatureVisitor visitReturnType() {
        return new ReferenceTypeSignatureParser(this.typeResolver, this.scope){

            @Override
            public void endType(AType type) {
                MethodSignatureParser.this.returnType = type;
            }
        };
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        return new ReferenceTypeSignatureParser(this.typeResolver, this.scope){

            @Override
            public void endType(AType type) {
                MethodSignatureParser.this.exceptions.add((Object)((ReferenceType)type));
            }
        };
    }
}

