/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.reporting.open.xml;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.junit.platform.commons.util.StringUtils;

interface GitInfoCollector {
    public static Optional<GitInfoCollector> get(Path workingDir) {
        ProcessExecutor executor = new ProcessExecutor(workingDir);
        boolean gitInstalled = executor.exec("git", "--version").isPresent();
        return gitInstalled ? Optional.of(new CliGitInfoCollector(executor)) : Optional.empty();
    }

    public Optional<String> getOriginUrl();

    public Optional<String> getBranch();

    public Optional<String> getCommitHash();

    public Optional<String> getStatus();

    public static class ProcessExecutor {
        private final Path workingDir;

        ProcessExecutor(Path workingDir) {
            this.workingDir = workingDir;
        }

        /*
         * Exception decompiling
         */
        Optional<String> exec(String ... args) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static BufferedReader newBufferedReader(InputStream stream) {
            return new BufferedReader(new InputStreamReader(stream, Charset.defaultCharset()));
        }

        private Process startProcess(String[] command) {
            Process process;
            try {
                process = new ProcessBuilder(new String[0]).directory(this.workingDir.toFile()).command(command).start();
            }
            catch (IOException e) {
                throw new UncheckedIOException("Failed to start process", e);
            }
            return process;
        }

        private static void readAllChars(Reader reader, BiConsumer<char[], Integer> consumer) throws IOException {
            int numChars;
            char[] buffer = new char[1024];
            while ((numChars = reader.read(buffer)) != -1) {
                consumer.accept(buffer, numChars);
            }
        }

        private static String trimAtEnd(StringBuilder value) {
            int endIndex = value.length();
            for (int i = value.length() - 1; i >= 0; --i) {
                if (!Character.isWhitespace(value.charAt(i))) continue;
                --endIndex;
                break;
            }
            return value.substring(0, endIndex);
        }

        private static /* synthetic */ void lambda$exec$1(char[] __, Integer ___) {
        }

        private static /* synthetic */ void lambda$exec$0(StringBuilder output, char[] chars, Integer numChars) {
            output.append(chars, 0, (int)numChars);
        }
    }

    public static class CliGitInfoCollector
    implements GitInfoCollector {
        private static final String ALLOWED_USERNAME = "git";
        private static final String USER_INFO_REPLACEMENT = "***";
        private static final String USER_INFO_SEPARATOR = "@";
        private final ProcessExecutor executor;

        public CliGitInfoCollector(ProcessExecutor executor) {
            this.executor = executor;
        }

        @Override
        public Optional<String> getOriginUrl() {
            return this.executor.exec(ALLOWED_USERNAME, "config", "--get", "remote.origin.url").filter(StringUtils::isNotBlank).flatMap(this::toGitUrl).flatMap(this::obfuscateUserInfo);
        }

        @Override
        public Optional<String> getBranch() {
            return this.executor.exec(ALLOWED_USERNAME, "rev-parse", "--abbrev-ref", "HEAD").filter(StringUtils::isNotBlank);
        }

        @Override
        public Optional<String> getCommitHash() {
            return this.executor.exec(ALLOWED_USERNAME, "rev-parse", "--verify", "HEAD").filter(StringUtils::isNotBlank);
        }

        @Override
        public Optional<String> getStatus() {
            return this.executor.exec(ALLOWED_USERNAME, "status", "--porcelain");
        }

        private Optional<String> obfuscateUserInfo(GitUrl gitUrl) {
            try {
                String oldAuthority;
                String[] parts;
                if (gitUrl.uri.getUserInfo() != null) {
                    URI newUri = new URI(gitUrl.uri.getScheme(), USER_INFO_REPLACEMENT, gitUrl.uri.getHost(), gitUrl.uri.getPort(), gitUrl.uri.getPath(), gitUrl.uri.getQuery(), gitUrl.uri.getFragment());
                    return Optional.of(newUri.toString().substring(gitUrl.addedPrefix.length()));
                }
                if (gitUrl.uri.getAuthority() != null && gitUrl.uri.getAuthority().contains(USER_INFO_SEPARATOR) && !ALLOWED_USERNAME.equals((parts = (oldAuthority = gitUrl.uri.getAuthority()).split(USER_INFO_SEPARATOR, 2))[0])) {
                    String newAuthority = "***@" + parts[1];
                    URI newUri = new URI(gitUrl.uri.getScheme(), newAuthority, gitUrl.uri.getPath(), gitUrl.uri.getQuery(), gitUrl.uri.getFragment());
                    return Optional.of(newUri.toString().substring(gitUrl.addedPrefix.length()));
                }
                return Optional.of(gitUrl.rawValue);
            }
            catch (URISyntaxException e) {
                return Optional.empty();
            }
        }

        private Optional<GitUrl> toGitUrl(String remoteUrl) {
            try {
                return Optional.of(new GitUrl(remoteUrl, new URI(remoteUrl), ""));
            }
            catch (URISyntaxException ex) {
                try {
                    return Optional.of(new GitUrl(remoteUrl, new URI("ssh://" + remoteUrl), "ssh://"));
                }
                catch (URISyntaxException ignore) {
                    return Optional.empty();
                }
            }
        }
    }

    public static class GitUrl {
        private final String rawValue;
        private final URI uri;
        private final String addedPrefix;

        GitUrl(String rawValue, URI uri, String addedPrefix) {
            this.rawValue = rawValue;
            this.uri = uri;
            this.addedPrefix = addedPrefix;
        }
    }
}

