/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.testengine.testcase.target;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import net.covers1624.coffeegrinder.bytecode.DebugPrintOptions;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.source.AstSourceVisitor;
import net.covers1624.coffeegrinder.source.JavaSourceVisitor;
import net.covers1624.coffeegrinder.source.LineBuffer;
import net.covers1624.coffeegrinder.testengine.api.Target;
import net.covers1624.coffeegrinder.testengine.testcase.target.TargetStepDescriptor;
import net.covers1624.coffeegrinder.testengine.testcase.target.TestCaseDescriptor;
import net.covers1624.coffeegrinder.testengine.testcase.util.OutputPath;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.quack.collection.FastStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.platform.engine.UniqueId;

public class SourceTargetStepDescriptor
extends TargetStepDescriptor {
    public SourceTargetStepDescriptor(UniqueId parentId) {
        super(parentId, Target.SOURCE);
    }

    @Override
    public void execute(TestCaseDescriptor testDescriptor) throws Throwable {
        ClassDecl clazz = testDescriptor.getClassDecl();
        String ast = (String)this.process(() -> SourceTargetStepDescriptor.emitAst(clazz));
        String source = (String)this.process(() -> SourceTargetStepDescriptor.emitSource(clazz, testDescriptor.typeResolver()));
        testDescriptor.setDecompSource(source);
        Assertions.assertAll((Executable[])new Executable[]{() -> SourceTargetStepDescriptor.compare(testDescriptor.outputAst, ast, testDescriptor), () -> SourceTargetStepDescriptor.compare(testDescriptor.outputSource, source, testDescriptor)});
    }

    private static String emitAst(ClassDecl classInsn) {
        DebugPrintOptions opts = new DebugPrintOptions(false, false, false, true, true, true, false);
        AstSourceVisitor astVisitor = new AstSourceVisitor(opts);
        LineBuffer ast = classInsn.accept(astVisitor);
        LinkedList lines = FastStream.of(astVisitor.getImports(classInsn)).map(e -> "import " + e).toLinkedList();
        if (!lines.isEmpty()) {
            lines.add("");
        }
        lines.addAll(ast.lines);
        return String.join((CharSequence)System.lineSeparator(), lines);
    }

    private static String emitSource(ClassDecl classInsn, TypeResolver typeResolver) {
        JavaSourceVisitor visitor = new JavaSourceVisitor(typeResolver);
        List<String> sourceLines = classInsn.accept(visitor).lines;
        return String.join((CharSequence)System.lineSeparator(), sourceLines);
    }

    private static void compare(OutputPath.Entry output, String result, TestCaseDescriptor testDescriptor) throws IOException {
        String previous = output.readOrNull();
        if (testDescriptor.root.updateOutput) {
            if (previous == null || !previous.equals(result)) {
                output.write(result);
            }
            return;
        }
        if (previous == null) {
            Assertions.assertFalse((boolean)testDescriptor.outputMandatory, (String)"Test requires output. Please re-run in update mode.");
            return;
        }
        Assertions.assertEquals((Object)previous, (Object)result);
    }
}

