/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.testengine.testcase.util;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.covers1624.coffeegrinder.testengine.testcase.TestCase;
import net.covers1624.coffeegrinder.testengine.testcase.util.PathHelper;
import net.covers1624.quack.io.IOUtils;
import org.jetbrains.annotations.Nullable;

public final class OutputPath
extends PathHelper {
    private final Path root;
    private final Set<Path> unusedFiles;

    public OutputPath(Path root, String extension) {
        super(extension);
        this.root = root;
        this.unusedFiles = OutputPath.loadAllFiles(root, extension);
    }

    public Path getPath() {
        return this.root;
    }

    public Entry pathFor(TestCase clazz) {
        return new Entry(this.root.resolve(this.nameFor(clazz)));
    }

    public void removeUnusedFiles() throws IOException {
        for (Path file : this.unusedFiles) {
            Files.deleteIfExists(file);
        }
    }

    @Nullable
    public static Entry optionalPathFor(@Nullable OutputPath path, TestCase clazz) {
        if (path == null) {
            return null;
        }
        return path.pathFor(clazz);
    }

    private static Set<Path> loadAllFiles(Path root, String extension) {
        Set<Path> set;
        block9: {
            if (Files.notExists(root, new LinkOption[0])) {
                return new HashSet<Path>();
            }
            Stream<Path> files = Files.walk(root, new FileVisitOption[0]);
            try {
                set = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(e -> e.getFileName().toString().endsWith(extension)).collect(Collectors.toSet());
                if (files == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ex) {
                    throw new RuntimeException("Failed to load all files.", ex);
                }
            }
            files.close();
        }
        return set;
    }

    public final class Entry {
        public final Path path;

        public Entry(Path path) {
            this.path = path;
        }

        public String relativePath() {
            return OutputPath.this.root.relativize(this.path).toString();
        }

        @Nullable
        public String readOrNull() throws IOException {
            this.trackUsed();
            if (Files.notExists(this.path, new LinkOption[0])) {
                return null;
            }
            return Files.readString(this.path);
        }

        public void write(String str) throws IOException {
            Files.writeString(IOUtils.makeParents((Path)this.path), (CharSequence)str, new OpenOption[0]);
            this.trackUsed();
        }

        public void trackUsed() {
            OutputPath.this.unusedFiles.remove(this.path);
        }
    }
}

