/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers.statement;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.AbstractInvoke;
import net.covers1624.coffeegrinder.bytecode.insns.BinaryOp;
import net.covers1624.coffeegrinder.bytecode.insns.CompoundAssignment;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNull;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNumber;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.New;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.PostIncrement;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.accessors.SyntheticAccessor;
import net.covers1624.coffeegrinder.util.None;
import net.covers1624.quack.collection.FastStream;

public class AccessorTransforms
extends SimpleInsnVisitor<StatementTransformContext>
implements StatementTransformer {
    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        statement.accept(this, ctx);
    }

    @Override
    public None visitInvoke(Invoke invoke, StatementTransformContext ctx) {
        this.process(invoke, ctx);
        return NONE;
    }

    @Override
    public None visitNew(New newInsn, StatementTransformContext ctx) {
        this.process(newInsn, ctx);
        return NONE;
    }

    private void process(AbstractInvoke invoke, StatementTransformContext ctx) {
        if (!invoke.getMethod().isSynthetic()) {
            return;
        }
        Method method = invoke.getMethod().getDeclaration();
        SyntheticAccessor accessor = method.getAccessor();
        if (accessor == null) {
            return;
        }
        ctx.pushStep("Replace accessor " + method.getName());
        this.replace(accessor, invoke, ctx);
        ctx.popStep();
    }

    private Instruction replace(SyntheticAccessor accessor, AbstractInvoke invoke, StatementTransformContext ctx) {
        return switch (accessor.type) {
            default -> throw new MatchException(null, null);
            case SyntheticAccessor.AccessorType.INVOKE -> this.replaceMethodAccessor((SyntheticAccessor.MethodAccessor)accessor, (Invoke)invoke);
            case SyntheticAccessor.AccessorType.FIELD_LOAD, SyntheticAccessor.AccessorType.FIELD_STORE -> this.replaceFieldAccessor((SyntheticAccessor.FieldAccessor)accessor, (Invoke)invoke);
            case SyntheticAccessor.AccessorType.FIELD_POST_INC, SyntheticAccessor.AccessorType.FIELD_PRE_INC -> this.replaceFieldIncrementAccessor((SyntheticAccessor.FieldIncrementAccessor)accessor, (Invoke)invoke);
            case SyntheticAccessor.AccessorType.CONSTRUCTOR -> this.replaceCtorAccessor((SyntheticAccessor.CtorAccessor)accessor, invoke, ctx);
        };
    }

    private Instruction replaceMethodAccessor(SyntheticAccessor.MethodAccessor accessor, Invoke usage) {
        Instruction target = accessor.method.isStatic() ? new Nop() : (Instruction)usage.getArguments().first();
        return usage.replaceWith(new Invoke(accessor.method.isStatic() ? Invoke.InvokeKind.STATIC : Invoke.InvokeKind.VIRTUAL, accessor.method.asRaw(), target, (Iterable<Instruction>)usage.getArguments().skip(accessor.method.isStatic() ? 0 : 1)));
    }

    private Instruction replaceFieldAccessor(SyntheticAccessor.FieldAccessor accessor, Invoke usage) {
        boolean isStatic = accessor.field.isStatic();
        FieldReference ref = new FieldReference(accessor.field.asRaw(), isStatic ? new Nop() : (Instruction)usage.getArguments().first());
        if (accessor.type == SyntheticAccessor.AccessorType.FIELD_LOAD) {
            return usage.replaceWith(new Load(ref));
        }
        Instruction value = isStatic ? (Instruction)usage.getArguments().first() : usage.getArguments().get(1);
        return usage.replaceWith(new Store(ref, value));
    }

    private Instruction replaceFieldIncrementAccessor(SyntheticAccessor.FieldIncrementAccessor accessor, Invoke usage) {
        boolean isStatic = accessor.field.isStatic();
        FieldReference ref = new FieldReference(accessor.field.asRaw(), isStatic ? new Nop() : (Instruction)usage.getArguments().first());
        if (accessor.type == SyntheticAccessor.AccessorType.FIELD_POST_INC) {
            return usage.replaceWith(new PostIncrement(ref, accessor.positive));
        }
        return usage.replaceWith(new CompoundAssignment(accessor.positive ? BinaryOp.ADD : BinaryOp.SUB, ref, new LdcNumber(1)));
    }

    private Instruction replaceCtorAccessor(SyntheticAccessor.CtorAccessor accessor, AbstractInvoke usage, StatementTransformContext ctx) {
        Load load = (Load)usage.getArguments().last();
        Store store = LoadStoreMatching.matchStoreLocal(usage.getPrevSibling(), load.getVariable());
        assert (store != null);
        assert (store.getValue() instanceof LdcNull);
        ctx.moveNext();
        store.remove();
        FastStream headArgs = usage.getArguments().limit(usage.getArguments().size() - 1);
        if (usage instanceof Invoke) {
            Invoke invoke = (Invoke)usage;
            assert (invoke.getKind() == Invoke.InvokeKind.SPECIAL);
            return usage.replaceWith(new Invoke(Invoke.InvokeKind.SPECIAL, accessor.method.asRaw(), invoke.getTarget(), (Iterable<Instruction>)headArgs));
        }
        return usage.replaceWith(new New(((New)usage).getResultType(), accessor.method.asRaw(), (Iterable<Instruction>)headArgs));
    }
}

