/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.SemanticMatcher;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.bytecode.insns.FieldDecl;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformer;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public class FieldInitializers
implements ClassTransformer {
    private ClassTransformContext ctx;

    @Override
    public void transform(ClassDecl cInsn, ClassTransformContext ctx) {
        this.ctx = ctx;
        LinkedList staticFields = cInsn.getFieldMembers().filter(f -> f.getField().isStatic()).toLinkedList();
        MethodDecl staticInitializer = (MethodDecl)cInsn.getMethodMembers().filter(f -> f.getMethod().getName().equals("<clinit>")).onlyOrDefault();
        if (staticInitializer != null) {
            Block staticInitializerBody = staticInitializer.getBody().getEntryPoint();
            this.processInitializers(staticFields, Collections.singletonList(() -> staticInitializerBody.instructions.firstOrDefault()));
        }
        LinkedList instanceFields = cInsn.getFieldMembers().filter(f -> !f.getField().isStatic()).toLinkedList();
        this.processInitializers(instanceFields, cInsn.getMethodMembers().map(InvokeMatching::getSuperConstructorCall).filter(Objects::nonNull).map(e -> e::getNextSiblingOrNull).toLinkedList());
    }

    private void processInitializers(List<FieldDecl> fields, List<Supplier<@Nullable Instruction>> potentialFieldInitSuppliers) {
        if (potentialFieldInitSuppliers.isEmpty()) {
            return;
        }
        int lastFieldIndex = -1;
        Store stfld;
        while ((stfld = LoadStoreMatching.matchStoreField(potentialFieldInitSuppliers.getFirst().get())) != null) {
            FieldDecl field = this.matchField(fields, ((FieldReference)stfld.getReference()).getField());
            if (field == null || fields.indexOf(field) <= lastFieldIndex) {
                return;
            }
            Instruction value = stfld.getValue();
            if (!value.descendantsWhere(FieldInitializers::isLoadParameter).isEmpty()) {
                return;
            }
            LinkedList<Store> stflds = new LinkedList<Store>();
            stflds.add(stfld);
            for (int i = 1; i < potentialFieldInitSuppliers.size(); ++i) {
                Instruction insn2 = potentialFieldInitSuppliers.get(i).get();
                if (insn2 == null || !new SemanticMatcher(null).equivalent(stfld, insn2)) {
                    return;
                }
                stflds.add((Store)insn2);
            }
            if (value instanceof Store) {
                return;
            }
            this.ctx.pushStep("Initializer for " + field.getField().getName());
            field.setValue(value);
            stflds.forEach(Instruction::remove);
            if (!field.getField().isSynthetic()) {
                lastFieldIndex = fields.indexOf(field);
            }
            this.ctx.popStep();
        }
        return;
    }

    private static boolean isLoadParameter(Instruction instruction) {
        Load load = LoadStoreMatching.matchLoadLocal(instruction);
        return load != null && load.getVariable().getKind() == LocalVariable.VariableKind.PARAMETER;
    }

    @Nullable
    private FieldDecl matchField(List<FieldDecl> fields, Field field) {
        return (FieldDecl)FastStream.of(fields).filter(f -> f.getField().getName().equals(field.getName())).onlyOrDefault();
    }
}

