/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.testengine.testcase.target;

import com.google.common.collect.ImmutableSet;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.covers1624.coffeegrinder.DecompilerSettings;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.testengine.api.Target;
import net.covers1624.coffeegrinder.testengine.testcase.TestCase;
import net.covers1624.coffeegrinder.testengine.testcase.TestCaseEngineDescriptor;
import net.covers1624.coffeegrinder.testengine.testcase.TestProcessingException;
import net.covers1624.coffeegrinder.testengine.testcase.TestUnabortableException;
import net.covers1624.coffeegrinder.testengine.testcase.target.TargetStepDescriptor;
import net.covers1624.coffeegrinder.testengine.testcase.util.OutputPath;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.util.resolver.ClassResolver;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.Nullable;
import org.junit.jupiter.api.Assertions;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.AbstractTestDescriptor;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.hierarchical.OpenTest4JAwareThrowableCollector;
import org.opentest4j.AssertionFailedError;
import org.opentest4j.TestAbortedException;

public class TestCaseDescriptor
extends AbstractTestDescriptor {
    public final TestCase testCase;
    public final TestCaseEngineDescriptor root;
    public final boolean outputMandatory;
    public final OutputPath.Entry outputAst;
    public final OutputPath.Entry outputSource;
    @Nullable
    public final OutputPath.Entry outputCompileError;
    @Nullable
    public final OutputPath.Entry outputRTDiff;
    public final Path inputRoot;
    public final Path inputClass;
    public final Set<Path> innerClassPaths;
    public final ClassResolver classResolver;
    public final DecompilerSettings settings = new DecompilerSettings();
    @Nullable
    private TypeResolver typeResolver;
    @Nullable
    private ClassDecl classDecl;
    @Nullable
    private String decompSource;
    @Nullable
    private Map<String, byte[]> compileOutput;
    @Nullable
    private Target outputsGenerated;

    public TestCaseDescriptor(UniqueId parentId, TestCase testCase, TestCaseEngineDescriptor root) {
        super(parentId.append("class", testCase.className), testCase.className, (TestSource)ClassSource.from((String)testCase.className));
        this.testCase = testCase;
        this.root = root;
        this.outputMandatory = testCase.className.startsWith(root.mandatoryOutputPackage);
        this.outputAst = root.outputAstPath.pathFor(testCase);
        this.outputSource = root.outputSourcePath.pathFor(testCase);
        this.outputCompileError = OutputPath.optionalPathFor(root.outputCompileErrorPath, testCase);
        this.outputRTDiff = OutputPath.optionalPathFor(root.outputRoundTripDiffsPath, testCase);
        this.inputRoot = root.inputClassPaths.getRoot();
        this.inputClass = root.inputClassPaths.getPathFor(testCase);
        this.innerClassPaths = ImmutableSet.copyOf(root.inputClassPaths.findInners(testCase));
        this.classResolver = root.classResolver;
        this.typeResolver = new TypeResolver(this.classResolver);
    }

    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    public TypeResolver typeResolver() {
        return Objects.requireNonNull(this.typeResolver);
    }

    public void execute(EngineExecutionListener listener) {
        listener.executionStarted((TestDescriptor)this);
        for (TargetStepDescriptor child : this.ourChildren()) {
            if (this.isBroken() || !this.doInputsForTargetExist(child.target)) {
                listener.executionSkipped((TestDescriptor)child, "Previous steps failed.");
                continue;
            }
            OpenTest4JAwareThrowableCollector collector = new OpenTest4JAwareThrowableCollector();
            listener.executionStarted((TestDescriptor)child);
            collector.execute(() -> this.executeTarget(child));
            listener.executionFinished((TestDescriptor)child, collector.toTestExecutionResult());
        }
        if (!this.root.updateLibraryDefs) {
            if (this.testCase.brokenData != null && this.testCase.processingError == null) {
                listener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)new AssertionFailedError("Test processing passed without crashes. Remove Broken")));
            } else if (this.testCase.processingError == null && this.testCase.reachedTarget != this.testCase.target) {
                listener.executionFinished((TestDescriptor)this, TestExecutionResult.failed((Throwable)new AssertionFailedError("Expected test case to reach " + String.valueOf(this.testCase.target) + " but we got to " + String.valueOf(this.testCase.reachedTarget))));
            } else {
                listener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
            }
        } else {
            listener.executionFinished((TestDescriptor)this, TestExecutionResult.successful());
        }
        this.typeResolver = null;
        this.classDecl = null;
        this.decompSource = null;
        this.compileOutput = null;
    }

    public void setClassDecl(ClassDecl decl) {
        this.classDecl = decl;
        this.outputsGenerated = Target.PROCESS;
    }

    public void setDecompSource(String decompSource) {
        this.decompSource = decompSource;
        this.outputsGenerated = Target.SOURCE;
    }

    public void setCompileOutput(Map<String, byte[]> compileOutput) {
        this.compileOutput = compileOutput;
        this.outputsGenerated = Target.COMPILE;
    }

    public ClassDecl getClassDecl() {
        return Objects.requireNonNull(this.classDecl, "ClassDecl does not exist.");
    }

    public String getDecompSource() {
        return Objects.requireNonNull(this.decompSource, "Decomp source does not exist.");
    }

    public Map<String, byte[]> getCompileOutput() {
        return Objects.requireNonNull(this.compileOutput, "Compile output does not exist.");
    }

    private boolean doInputsForTargetExist(Target target) {
        if (target == Target.PROCESS) {
            return true;
        }
        if (this.outputsGenerated == null) {
            return false;
        }
        return this.outputsGenerated.ordinal() >= target.ordinal() - 1;
    }

    private boolean isBroken() {
        return this.testCase.processingError != null;
    }

    private void executeTarget(TargetStepDescriptor step) throws Throwable {
        boolean isRequested = step.target.ordinal() <= this.testCase.target.ordinal();
        try {
            step.execute(this);
            this.testCase.reachedTarget = step.target;
        }
        catch (TestProcessingException processingException) {
            Throwable cause = processingException.getCause();
            this.testCase.processingError = new TestCase.BrokenData(cause.getClass(), false, cause.getMessage(), ExceptionUtils.getStackTrace((Throwable)cause));
            if (this.root.updateLibraryDefs) {
                return;
            }
            if (!isRequested) {
                throw new TestAbortedException("Test failure expected.", !this.root.terseTestAborts ? cause : null);
            }
            if (this.testCase.brokenData == null) {
                Assertions.fail((String)("Test was expected to reach " + String.valueOf(this.testCase.target) + " but we crashed on " + String.valueOf(step.target)), (Throwable)cause);
            }
            if (this.testCase.brokenData.expected != cause.getClass()) {
                Assertions.fail((String)("Test now fails with a different exception. Expected: " + this.testCase.brokenData.expected.getName() + " Got: " + cause.getClass().getName()), (Throwable)cause);
            }
            if (!this.testCase.brokenData.ignoreExceptionMessages) {
                Assertions.assertEquals((Object)this.testCase.brokenData.message, (Object)cause.getMessage(), (String)"Test now fails with a different exception message.");
            }
        }
        catch (TestUnabortableException unabortableException) {
            if (this.root.updateLibraryDefs) {
                return;
            }
            throw unabortableException.getCause();
        }
        catch (Throwable ex) {
            if (this.root.updateLibraryDefs) {
                return;
            }
            if (!isRequested) {
                throw new TestAbortedException("Test failure expected.", !this.root.terseTestAborts ? ex : null);
            }
            throw ex;
        }
        if (!this.root.updateLibraryDefs && !isRequested) {
            Assertions.fail((String)("Test case was only expected to pass " + String.valueOf(this.testCase.target) + " but we have reached " + String.valueOf(step.target)));
        }
    }

    private Set<TargetStepDescriptor> ourChildren() {
        return this.getChildren();
    }
}

