/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.jdkutils.locator;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.covers1624.jdkutils.JavaInstall;
import net.covers1624.jdkutils.locator.JavaLocator;

public class GradleJavaLocator
extends JavaLocator {
    GradleJavaLocator(boolean useJavaw) {
        super(useJavaw);
    }

    @Override
    public List<JavaInstall> findJavaVersions() throws IOException {
        ArrayList<JavaInstall> installs = new ArrayList<JavaInstall>();
        for (Path candidatePath : GradleJavaLocator.listDir(Paths.get(System.getProperty("user.home"), ".gradle/jdks"))) {
            if (!Files.isDirectory(candidatePath, new LinkOption[0])) continue;
            Path executable = this.getJavaExecutable(candidatePath);
            if (Files.exists(executable, new LinkOption[0])) {
                GradleJavaLocator.addJavaInstall(installs, JavaInstall.parse(executable));
                continue;
            }
            List<Path> inners = GradleJavaLocator.listDir(candidatePath);
            if (inners.size() != 1) continue;
            GradleJavaLocator.addJavaInstall(installs, JavaInstall.parse(this.getJavaExecutable(inners.get(0))));
        }
        return installs;
    }
}

