/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Reference;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public final class Store
extends Instruction {
    private final InstructionSlot<Reference> reference = new InstructionSlot(this);
    private final InstructionSlot<Instruction> value = new InstructionSlot(this);

    public Store(Reference reference, Instruction value) {
        this.reference.set(reference);
        this.value.set(value);
    }

    @Override
    public AType getResultType() {
        return this.getReference().getType();
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitStore(this, ctx);
    }

    public LocalVariable getVariable() {
        return ((LocalReference)this.getReference()).variable;
    }

    @Override
    protected void onChildModified() {
        super.onChildModified();
        if (this.isConnected()) {
            this.getReference().setWrittenTo(true);
        }
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        this.getReference().setWrittenTo(true);
    }

    public Reference getReference() {
        return this.reference.get();
    }

    public Instruction getValue() {
        return this.value.get();
    }
}

