/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.util;

import java.util.BitSet;
import java.util.EnumSet;
import net.covers1624.quack.util.Copyable;
import net.covers1624.quack.util.SneakyUtils;

public class EnumBitSet<E extends Enum<E>>
extends BitSet
implements Copyable<EnumBitSet<E>> {
    private final Class<E> elementType;

    private EnumBitSet(Class<E> clazz) {
        super(((Enum[])clazz.getEnumConstants()).length);
        this.elementType = clazz;
    }

    public static <T extends Enum<T>> EnumBitSet<T> noneOf(Class<T> clazz) {
        return new EnumBitSet<T>(clazz);
    }

    @SafeVarargs
    public static <T extends Enum<T>> EnumBitSet<T> of(T ... elements) {
        if (elements.length == 0) {
            throw new IllegalArgumentException("Elements should not be empty");
        }
        T first = elements[0];
        EnumBitSet<T> set = EnumBitSet.noneOf(((Enum)first).getDeclaringClass());
        for (T element : elements) {
            set.set(element);
        }
        return set;
    }

    public static <T extends Enum<T>> EnumBitSet<T> copyOf(EnumBitSet<T> other) {
        EnumBitSet<Enum> copy = EnumBitSet.noneOf(other.elementType);
        for (Enum e : (Enum[])other.elementType.getEnumConstants()) {
            if (!other.get(e)) continue;
            copy.set(e);
        }
        return copy;
    }

    public void flip(E bit) {
        super.flip(((Enum)bit).ordinal());
    }

    public boolean get(E bit) {
        return super.get(((Enum)bit).ordinal());
    }

    public void set(E bit) {
        super.set(((Enum)bit).ordinal());
    }

    public void clear(E bit) {
        super.clear(((Enum)bit).ordinal());
    }

    public EnumSet<E> toSet() {
        EnumSet<Enum> set = EnumSet.noneOf(this.elementType);
        for (Enum e : (Enum[])this.elementType.getEnumConstants()) {
            if (!this.get(e)) continue;
            set.add(e);
        }
        return set;
    }

    @Override
    public EnumBitSet<E> clone() {
        return (EnumBitSet)SneakyUtils.unsafeCast((Object)super.clone());
    }

    public EnumBitSet<E> copy() {
        return EnumBitSet.copyOf(this);
    }

    @Override
    public String toString() {
        return this.toSet().toString();
    }
}

