package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.*;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;
import net.covers1624.quack.collection.FastStream;

import java.util.HashSet;
import java.util.Set;

/**
 * Created by covers1624 on 8/2/24.
 */
public class SwitchExpressions implements StatementTransformer {

    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        if (!(statement instanceof Switch sSwitch)) return;
        BlockContainer switchBody = sSwitch.getBody();
        // STORE(s_1, ...)
        // LEAVE L0_switch
        Set<LocalVariable> candidateVars = new HashSet<>();
        for (Leave leave : switchBody.getLeaves()) {
            if (!(leave.getPrevSiblingOrNull() instanceof Store store)) return;

            // Local var must be stack slot.
            if (!(store.getReference() instanceof LocalReference r)) return;
            if (r.variable.getKind() != LocalVariable.VariableKind.STACK_SLOT) return;
            candidateVars.add(r.variable);
        }
        LocalVariable stackVar = FastStream.of(candidateVars).onlyOrDefault();
        // We did not find exactly one distinct var, not switch expression.
        if (stackVar == null) return;
        if (stackVar.getLoadCount() != 1) return;

        ctx.pushStep("Produce switch expression.");
        Switch newSwitch = new Switch(sSwitch.getValue(), switchBody, stackVar.getType());
        for (Leave leave : switchBody.getLeaves().toList()) {
            Store store = (Store) leave.getPrevSibling();
            leave.replaceWith(new Yield(newSwitch, store.getValue()).withOffsets(leave));
            store.remove();
        }
        sSwitch.replaceWith(new Store(new LocalReference(stackVar), newSwitch));
        ctx.popStep();
    }
}
