package net.covers1624.coffeegrinder.bytecode.transform;

import net.covers1624.coffeegrinder.bytecode.insns.Block;

/**
 * A Transform capable of running over an individual block.
 * <p>
 * Created by covers1624 on 19/4/21.
 */
public interface BlockTransformer extends Transformer {

    /**
     * Runs the transform on the specified block.
     *
     * @param block The block to transform.
     * @param ctx   Additional context provided to the transform.
     */
    void transform(Block block, BlockTransformContext ctx);

}
