package net.covers1624.coffeegrinder.type;

import net.covers1624.quack.collection.FastStream;
import org.objectweb.asm.Type;

import java.util.Map;

/**
 * Created by covers1624 on 12/4/21.
 */
public class PrimitiveType extends AType {

    public static final PrimitiveType VOID = new PrimitiveType("void", Type.VOID_TYPE, Void.class);
    public static final PrimitiveType BOOLEAN = new PrimitiveType("boolean", Type.BOOLEAN_TYPE, Boolean.class);
    public static final PrimitiveType CHAR = new PrimitiveType("char", Type.CHAR_TYPE, Character.class);
    public static final PrimitiveType BYTE = new PrimitiveType("byte", Type.BYTE_TYPE, Byte.class);
    public static final PrimitiveType SHORT = new PrimitiveType("short", Type.SHORT_TYPE, Short.class);
    public static final PrimitiveType INT = new PrimitiveType("int", Type.INT_TYPE, Integer.class);
    public static final PrimitiveType FLOAT = new PrimitiveType("float", Type.FLOAT_TYPE, Float.class);
    public static final PrimitiveType LONG = new PrimitiveType("long", Type.LONG_TYPE, Long.class);
    public static final PrimitiveType DOUBLE = new PrimitiveType("double", Type.DOUBLE_TYPE, Double.class);

    public static final PrimitiveType[] PRIMITIVE_TYPES = new PrimitiveType[] {
            VOID,
            BOOLEAN,
            CHAR,
            BYTE,
            SHORT,
            INT,
            FLOAT,
            LONG,
            DOUBLE
    };

    public static final Map<String, PrimitiveType> UNBOX_LOOKUP = FastStream.of(PRIMITIVE_TYPES)
            .toImmutableMap(e -> e.getBoxedClass().getName(), e -> e);

    private final String name;
    private final Type type;
    private final Class<?> boxedClass;

    private PrimitiveType(String name, Type type, Class<?> boxedClass) {
        this.name = name;
        this.type = type;
        this.boxedClass = boxedClass;
    }

    @Override
    public String getName() {
        return name;
    }

    public Type getDescriptor() {
        return type;
    }

    public Class<?> getBoxedClass() {
        return boxedClass;
    }

    @Override
    public String toString() {
        return "PrimitiveType(" + name + ")";
    }
}
