/*
 * Decompiled with CFR 0.152.
 */
package io.codechicken.diffpatch.cli;

import io.codechicken.diffpatch.cli.ArchiveFormatValueConverter;
import io.codechicken.diffpatch.cli.CliOperation;
import io.codechicken.diffpatch.cli.DiffOperation;
import io.codechicken.diffpatch.cli.PatchModeValueConverter;
import io.codechicken.diffpatch.cli.PatchOperation;
import io.codechicken.diffpatch.util.Input;
import io.codechicken.diffpatch.util.LogLevel;
import io.codechicken.diffpatch.util.Output;
import io.codechicken.diffpatch.util.PatchMode;
import io.codechicken.diffpatch.util.archiver.ArchiveFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.EnumConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class DiffPatchCli {
    public static void main(String[] args) throws IOException {
        System.exit(DiffPatchCli.mainI(args, System.err, System.out));
    }

    public static int mainI(String[] args, PrintStream logger, PrintStream pipe) throws IOException {
        CliOperation<?> operation = DiffPatchCli.parseOperation(logger, pipe, args);
        if (operation == null) {
            return -1;
        }
        return operation.operate().exit;
    }

    @VisibleForTesting
    @Nullable
    static CliOperation<?> parseOperation(PrintStream logger, PrintStream pipe, String ... args) throws IOException {
        OptionParser parser = new OptionParser();
        NonOptionArgumentSpec nonOptions = parser.nonOptions();
        AbstractOptionSpec helpOpt = parser.acceptsAll(Arrays.asList("h", "help"), "Prints this help.").forHelp();
        OptionSpecBuilder verboseOpt = parser.acceptsAll(Arrays.asList("v", "verbose"), "Prints more stuff. Alias for --log-level ALL");
        ArgumentAcceptingOptionSpec logLevelOpt = parser.acceptsAll(Arrays.asList("l", "log-level"), "Set the Logging level.").availableUnless((OptionSpec)verboseOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy((ValueConverter)new EnumConverter<LogLevel>(LogLevel.class){}).defaultsTo((Object)LogLevel.INFO, (Object[])new LogLevel[0]);
        OptionSpecBuilder summaryOpt = parser.acceptsAll(Arrays.asList("s", "summary"), "Prints a changes summary at the end.");
        ArgumentAcceptingOptionSpec outputOpt = parser.acceptsAll(Arrays.asList("o", "output"), "Sets the output path.").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec archiveOpt = parser.acceptsAll(Arrays.asList("A", "archive"), "Treat output as an archive. Allows printing multi-output to STDOUT.").withRequiredArg().withValuesConvertedBy((ValueConverter)new ArchiveFormatValueConverter());
        ArgumentAcceptingOptionSpec baseArchiveOpt = parser.acceptsAll(Arrays.asList("B", "archive-base"), "Treat the base path as an archive.").withRequiredArg().withValuesConvertedBy((ValueConverter)new ArchiveFormatValueConverter());
        ArgumentAcceptingOptionSpec basePathPrefixOpt = parser.acceptsAll(Arrays.asList("base-path-prefix"), "The prefix to assume for paths of base files.").withRequiredArg().ofType(String.class).defaultsTo((Object)"a/", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec modifiedPathPrefixOpt = parser.acceptsAll(Arrays.asList("modified-path-prefix"), "The prefix to assume for paths of modified files.").withRequiredArg().ofType(String.class).defaultsTo((Object)"b/", (Object[])new String[0]);
        OptionSpecBuilder doDiffOpt = parser.acceptsAll(Arrays.asList("d", "diff"), "Does a Diff operation.");
        OptionSpecBuilder autoHeaderOpt = parser.acceptsAll(Arrays.asList("h", "auto-header"), "Enables the generation of auto-headers. Using _ as the start2 index.").availableIf((OptionSpec)doDiffOpt, new OptionSpec[0]);
        ArgumentAcceptingOptionSpec contextOpt = parser.acceptsAll(Arrays.asList("c", "context"), "Number of context lines to generate in diffs.").availableIf((OptionSpec)doDiffOpt, new OptionSpec[0]).withRequiredArg().ofType(Integer.class).defaultsTo((Object)3, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec modifiedArchiveOpt = parser.acceptsAll(Arrays.asList("M", "archive-modified"), "Treat the modified path as an archive.").availableIf((OptionSpec)doDiffOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy((ValueConverter)new ArchiveFormatValueConverter());
        OptionSpecBuilder doPatchOpt = parser.acceptsAll(Arrays.asList("p", "patch"), "Does a Patch operation.");
        ArgumentAcceptingOptionSpec rejectOpt = parser.acceptsAll(Arrays.asList("r", "reject"), "Saves patch rejects to the specified path / archive").availableIf((OptionSpec)doPatchOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        ArgumentAcceptingOptionSpec rejectArchiveOpt = parser.acceptsAll(Arrays.asList("H", "archive-rejects"), "Treat reject output as an archive.").availableIf((OptionSpec)doPatchOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy((ValueConverter)new ArchiveFormatValueConverter());
        ArgumentAcceptingOptionSpec fuzzOpt = parser.acceptsAll(Arrays.asList("f", "fuzz"), "The minimum fuzz match quality, anything lower will be treated as a failure.").availableIf((OptionSpec)doPatchOpt, new OptionSpec[0]).withRequiredArg().ofType(Float.class).defaultsTo((Object)Float.valueOf(0.5f), (Object[])new Float[0]);
        ArgumentAcceptingOptionSpec offsetOpt = parser.acceptsAll(Arrays.asList("O", "offset"), "The max line offset allowed for fuzzy matching, larger than this will be treated as a failure.").availableIf((OptionSpec)doPatchOpt, new OptionSpec[0]).withRequiredArg().ofType(Integer.class).defaultsTo((Object)5, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec modeOpt = parser.acceptsAll(Arrays.asList("m", "mode"), "The desired patching mode.").availableIf((OptionSpec)doPatchOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy((ValueConverter)new PatchModeValueConverter()).defaultsTo((Object)PatchMode.EXACT, (Object[])new PatchMode[0]);
        ArgumentAcceptingOptionSpec patchPrefix = parser.acceptsAll(Arrays.asList("P", "prefix"), "Prefix path for reading patches from patches input.").availableIf((OptionSpec)doPatchOpt, new OptionSpec[0]).withRequiredArg().ofType(String.class).defaultsTo((Object)"", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec patchesArchiveOpt = parser.acceptsAll(Arrays.asList("N", "archive-patches"), "Treat the patches path as an archive.").availableIf((OptionSpec)doPatchOpt, new OptionSpec[0]).withRequiredArg().withValuesConvertedBy((ValueConverter)new ArchiveFormatValueConverter());
        OptionSet optSet = parser.parse(args);
        if (optSet.has((OptionSpec)helpOpt)) {
            parser.printHelpOn((OutputStream)logger);
            return null;
        }
        LogLevel level = (LogLevel)((Object)optSet.valueOf((OptionSpec)logLevelOpt));
        if (level == null) {
            level = optSet.has((OptionSpec)summaryOpt) ? LogLevel.DEBUG : LogLevel.INFO;
        }
        boolean summary = optSet.has((OptionSpec)summaryOpt);
        List arguments = optSet.valuesOf((OptionSpec)nonOptions);
        if (arguments.size() != 2) {
            logger.println("Expected 2 arguments, got: " + arguments.size());
            parser.printHelpOn((OutputStream)logger);
            return null;
        }
        if (optSet.has((OptionSpec)doDiffOpt)) {
            Input.MultiInput aInput;
            Path aPath = Paths.get((String)arguments.get(0), new String[0]);
            Path bPath = Paths.get((String)arguments.get(1), new String[0]);
            Path outputPath = (Path)optSet.valueOf((OptionSpec)outputOpt);
            ArchiveFormat aFormat = DiffPatchCli.detectFormat((ArchiveFormat)((Object)optSet.valueOf((OptionSpec)baseArchiveOpt)), aPath);
            ArchiveFormat bFormat = DiffPatchCli.detectFormat((ArchiveFormat)((Object)optSet.valueOf((OptionSpec)modifiedArchiveOpt)), bPath);
            ArchiveFormat outputFormat = DiffPatchCli.detectFormat((ArchiveFormat)((Object)optSet.valueOf((OptionSpec)archiveOpt)), outputPath);
            String basePathPrefix = (String)optSet.valueOf((OptionSpec)basePathPrefixOpt);
            String modifiedPathPrefix = (String)optSet.valueOf((OptionSpec)modifiedPathPrefixOpt);
            Output output = outputFormat != null ? (outputPath != null ? Output.MultiOutput.archive(outputFormat, outputPath) : Output.MultiOutput.archive(outputFormat, pipe)) : (outputPath != null ? (Files.isDirectory(outputPath, new LinkOption[0]) ? Output.MultiOutput.folder(outputPath) : Output.SingleOutput.path(outputPath, new OpenOption[0])) : Output.SingleOutput.pipe(pipe));
            if (aFormat != null) {
                aInput = Input.MultiInput.archive(aFormat, aPath);
            } else {
                Input input = aInput = Files.isDirectory(aPath, new LinkOption[0]) ? Input.MultiInput.folder(aPath) : Input.SingleInput.path(aPath, new OpenOption[0]);
            }
            Input bInput = bFormat != null ? Input.MultiInput.archive(bFormat, bPath) : (Files.isDirectory(bPath, new LinkOption[0]) ? Input.MultiInput.folder(bPath) : Input.SingleInput.path(bPath, new OpenOption[0]));
            return DiffOperation.builder().logTo(logger).helpCallback(SneakyUtils.sneak(arg_0 -> ((OptionParser)parser).printHelpOn(arg_0))).baseInput(aInput).changedInput(bInput).patchesOutput(output).level(level).summary(summary).autoHeader(optSet.has((OptionSpec)autoHeaderOpt)).context((Integer)optSet.valueOf((OptionSpec)contextOpt)).aPrefix(basePathPrefix).bPrefix(modifiedPathPrefix).build();
        }
        if (optSet.has((OptionSpec)doPatchOpt)) {
            Input.MultiInput patchesInput;
            Input.MultiInput baseInput;
            Path base = Paths.get((String)arguments.get(0), new String[0]);
            Path patches = Paths.get((String)arguments.get(1), new String[0]);
            Path outputPath = (Path)optSet.valueOf((OptionSpec)outputOpt);
            Path rejectsPath = (Path)optSet.valueOf((OptionSpec)rejectOpt);
            ArchiveFormat baseFormat = DiffPatchCli.detectFormat((ArchiveFormat)((Object)optSet.valueOf((OptionSpec)baseArchiveOpt)), base);
            ArchiveFormat patchesFormat = DiffPatchCli.detectFormat((ArchiveFormat)((Object)optSet.valueOf((OptionSpec)patchesArchiveOpt)), patches);
            ArchiveFormat outputFormat = DiffPatchCli.detectFormat((ArchiveFormat)((Object)optSet.valueOf((OptionSpec)archiveOpt)), outputPath);
            ArchiveFormat rejectsFormat = DiffPatchCli.detectFormat((ArchiveFormat)((Object)optSet.valueOf((OptionSpec)rejectArchiveOpt)), rejectsPath);
            String basePathPrefix = (String)optSet.valueOf((OptionSpec)basePathPrefixOpt);
            String modifiedPathPrefix = (String)optSet.valueOf((OptionSpec)modifiedPathPrefixOpt);
            if (baseFormat != null) {
                baseInput = Input.MultiInput.archive(baseFormat, base);
            } else {
                Input input = baseInput = Files.isDirectory(base, new LinkOption[0]) ? Input.MultiInput.folder(base) : Input.SingleInput.path(base, new OpenOption[0]);
            }
            if (patchesFormat != null) {
                patchesInput = Input.MultiInput.archive(patchesFormat, patches);
            } else {
                Input input = patchesInput = Files.isDirectory(patches, new LinkOption[0]) ? Input.MultiInput.folder(patches) : Input.SingleInput.path(patches, new OpenOption[0]);
            }
            Output output = outputFormat != null ? (outputPath != null ? Output.MultiOutput.archive(outputFormat, outputPath) : Output.MultiOutput.archive(outputFormat, pipe)) : (outputPath != null ? (Files.isDirectory(outputPath, new LinkOption[0]) ? Output.MultiOutput.folder(outputPath) : Output.SingleOutput.path(outputPath, new OpenOption[0])) : Output.SingleOutput.pipe(pipe));
            Output rejects = null;
            if (rejectsPath != null) {
                rejects = rejectsFormat != null ? Output.MultiOutput.archive(rejectsFormat, rejectsPath) : (Files.isDirectory(rejectsPath, new LinkOption[0]) ? Output.MultiOutput.folder(rejectsPath) : Output.SingleOutput.path(rejectsPath, new OpenOption[0]));
            }
            return PatchOperation.builder().logTo(logger).helpCallback(SneakyUtils.sneak(arg_0 -> ((OptionParser)parser).printHelpOn(arg_0))).level(level).summary(summary).baseInput(baseInput).patchesInput(patchesInput).patchedOutput(output).rejectsOutput(rejects).minFuzz(((Float)optSet.valueOf((OptionSpec)fuzzOpt)).floatValue()).maxOffset((Integer)optSet.valueOf((OptionSpec)offsetOpt)).mode((PatchMode)((Object)optSet.valueOf((OptionSpec)modeOpt))).patchesPrefix((String)optSet.valueOf((OptionSpec)patchPrefix)).aPrefix(basePathPrefix).bPrefix(modifiedPathPrefix).build();
        }
        logger.println("Expected --diff or --patch.");
        parser.printHelpOn((OutputStream)logger);
        return null;
    }

    @Nullable
    private static ArchiveFormat detectFormat(@Nullable ArchiveFormat existing, @Nullable Path detectFrom) {
        if (existing != null) {
            return existing;
        }
        if (detectFrom != null) {
            return ArchiveFormat.findFormat(detectFrom.getFileName());
        }
        return null;
    }
}

