/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers.generics;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.NotNull;

public class TarjanDepthFirstIterator<T>
implements Iterable<List<T>>,
Iterator<List<T>> {
    private final Function<T, Iterable<T>> successors;
    private final Object2IntMap<T> ids = new Object2IntOpenHashMap();
    private final T[] elements;
    private final int[] dfn;
    private final int[] low;
    private final int[] stack;
    private final BitSet onStack;
    private int top;
    private int index;
    private final LinkedList<List<T>> next = new LinkedList();

    public TarjanDepthFirstIterator(Collection<T> nodes, Function<T, Iterable<T>> successors) {
        this.successors = successors;
        int t = 0;
        this.elements = (Object[])SneakyUtils.unsafeCast((Object)new Object[nodes.size()]);
        for (T node : nodes) {
            this.ids.put(node, t);
            this.elements[t] = node;
            ++t;
        }
        int n = nodes.size();
        this.dfn = new int[n];
        this.low = new int[n];
        this.stack = new int[n];
        this.onStack = new BitSet(n);
        this.top = -1;
    }

    @Override
    @NotNull
    public Iterator<List<T>> iterator() {
        return this;
    }

    private void push(int i) {
        this.stack[++this.top] = i;
        this.onStack.set(i);
    }

    private void pop() {
        this.onStack.clear(this.stack[this.top--]);
    }

    private void dfs(int now) {
        if (this.dfn[now] == 0) {
            this.dfs(now, 1);
        }
    }

    private void dfs(int now, int depth) {
        int t;
        this.dfn[now] = depth;
        this.low[now] = depth;
        this.push(now);
        for (T each : this.successors.apply(this.elements[now])) {
            int to = this.ids.getInt(each);
            if (this.dfn[to] != 0) {
                if (this.low[now] <= this.dfn[to]) continue;
                this.low[now] = this.dfn[to];
                continue;
            }
            this.dfs(to, depth + 1);
            if (this.low[now] <= this.low[to]) continue;
            this.low[now] = this.low[to];
        }
        if (this.dfn[now] != this.low[now]) {
            return;
        }
        if (this.stack[this.top] == now) {
            this.pop();
            this.next.addLast(List.of(this.elements[now]));
            return;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        do {
            t = this.stack[this.top];
            builder.add(this.elements[t]);
            this.pop();
        } while (t != now);
        this.next.addLast((List<T>)builder.build());
    }

    @Override
    public boolean hasNext() {
        while (this.index < this.elements.length && this.next.isEmpty()) {
            this.dfs(this.index++);
        }
        return !this.next.isEmpty();
    }

    @Override
    public List<T> next() {
        return this.next.removeFirst();
    }
}

