/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers.statement;

import java.util.LinkedList;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNumber;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.Ternary;
import net.covers1624.coffeegrinder.bytecode.matching.LdcMatching;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.Inlining;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.util.None;

public class TernaryExpressions
extends SimpleInsnVisitor<None>
implements StatementTransformer {
    private StatementTransformContext ctx;

    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        this.ctx = ctx;
        statement.accept(this);
    }

    @Override
    public None visitBlock(Block block, None ctx) {
        return NONE;
    }

    @Override
    public None visitIfInstruction(IfInstruction ifInsn, None ctx) {
        ifInsn.getTrueInsn().accept(this);
        ifInsn.getFalseInsn().accept(this);
        Instruction cond = ifInsn.getCondition();
        this.handleConditionalOperator(ifInsn);
        cond.accept(this);
        return NONE;
    }

    private Instruction handleConditionalOperator(IfInstruction insn) {
        Instruction instruction = insn.getTrueInsn();
        if (!(instruction instanceof Block)) {
            return insn;
        }
        Block trueInsn = (Block)instruction;
        Instruction instruction2 = insn.getFalseInsn();
        if (!(instruction2 instanceof Block)) {
            return insn;
        }
        Block falseInsn = (Block)instruction2;
        LinkedList<Runnable> extraTransforms = new LinkedList<Runnable>();
        Store store1 = Inlining.matchWithPotentialInline(trueInsn.getFirstChildOrNull(), extraTransforms, this.ctx, e -> e.getNextSiblingOrNull() != null ? null : LoadStoreMatching.matchStoreLocal(e));
        if (store1 == null) {
            return insn;
        }
        LocalVariable var = store1.getVariable();
        if (var.getKind() != LocalVariable.VariableKind.STACK_SLOT) {
            return insn;
        }
        Store store2 = Inlining.matchWithPotentialInline(falseInsn.getFirstChild(), extraTransforms, this.ctx, e -> e.getNextSiblingOrNull() != null ? null : LoadStoreMatching.matchStoreLocal(e, var));
        if (store2 == null) {
            return insn;
        }
        this.ctx.pushStep("Produce ternary for store");
        extraTransforms.forEach(Runnable::run);
        Ternary ternary = (Ternary)new Ternary(insn.getCondition(), store1.getValue(), store2.getValue()).withOffsets(insn);
        insn.replaceWith(new Store(new LocalReference(var), ternary).withOffsets(insn));
        this.insertCastForConstantTernaryIfNecessary(ternary, var.getType());
        this.ctx.popStep();
        return ternary;
    }

    private void insertCastForConstantTernaryIfNecessary(Ternary ternary, AType type) {
        if (ternary.getResultType() != PrimitiveType.INT) {
            return;
        }
        if (TypeSystem.isAssignableTo(ternary.getResultType(), type)) {
            return;
        }
        assert (TernaryExpressions.isAssignableIntegerConstant(ternary, type));
        this.ctx.pushStep("Add cast");
        ternary.getTrueInsn().replaceWith(new Cast(ternary.getTrueInsn(), type));
        this.ctx.popStep();
    }

    private static boolean isAssignableIntegerConstant(Instruction insn, AType expectedType) {
        if (insn instanceof Ternary) {
            Ternary ternary = (Ternary)insn;
            return TernaryExpressions.isAssignableIntegerConstant(ternary.getTrueInsn(), expectedType) && TernaryExpressions.isAssignableIntegerConstant(ternary.getFalseInsn(), expectedType);
        }
        LdcNumber ldc = LdcMatching.matchLdcInt(insn);
        if (ldc != null) {
            return TypeSystem.isAssignableTo(ldc.getResultType(), expectedType);
        }
        return false;
    }
}

