/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.debug;

import java.util.LinkedList;
import java.util.function.Supplier;
import net.covers1624.coffeegrinder.bytecode.DebugPrintOptions;
import net.covers1624.coffeegrinder.debug.DebugStopAtStep;
import net.covers1624.coffeegrinder.debug.Step;
import net.covers1624.coffeegrinder.debug.Stepper;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;

public class DebugStepper
implements Stepper {
    private final DebugPrintOptions opts;
    private final int stopAtStep;
    private final LinkedList<Supplier<String>> contextStack = new LinkedList();
    private int nextStepId;
    @Nullable
    private Step root = null;
    @Nullable
    private Throwable exception;
    private final LinkedList<Step> steps = new LinkedList();

    public DebugStepper(DebugPrintOptions opts, int stopAtStep) {
        this.opts = opts;
        this.stopAtStep = stopAtStep;
    }

    @Override
    public DebugPrintOptions getOpts() {
        return this.opts;
    }

    @Override
    public void pushContext(Supplier<String> contentSupp) {
        this.contextStack.push(contentSupp);
    }

    @Override
    public void popContext() {
        this.contextStack.pop();
    }

    @Override
    public Step pushStep(String name) {
        return this.step(Step.StepType.CONTENT, Step.StepContextType.NONE, name, null);
    }

    @Override
    public Step pushStep(String name, Step.StepContextType contextType) {
        return this.step(Step.StepType.CONTENT, contextType, name, null);
    }

    @Override
    public Step pushStepWithContent(String name, Step.StepContextType contextType, Supplier<String> preContent) {
        return this.step(Step.StepType.CONTENT, contextType, name, preContent.get());
    }

    @Override
    public void popStep() {
        Step step = this.steps.pop();
        if (step.finish()) {
            this.insertPostMicroStep(step);
        }
    }

    @Override
    public Step pushTiming(String name) {
        return this.step(Step.StepType.TIMING, Step.StepContextType.NONE, name, null);
    }

    private Step step(Step.StepType type, Step.StepContextType contextType, String name, @Nullable String preContent) {
        Step parent = this.steps.peek();
        Supplier<String> supplier = null;
        if (type != Step.StepType.TIMING) {
            supplier = this.contextStack.peek();
            assert (supplier != null) : "Attempted to step without context.";
            this.insertPushMicroStep(parent, supplier);
        }
        Step step = new Step(this, this.nextStepId(), type, contextType, name, parent, preContent, supplier);
        this.steps.push(step);
        if (parent != null) {
            assert (!parent.isFinished);
            parent.children.add(step);
        } else {
            this.root = step;
        }
        return step;
    }

    private void insertPushMicroStep(@Nullable Step parent, Supplier<String> supplier) {
        String content;
        long start;
        Step prevStep;
        if (parent == null) {
            return;
        }
        Step step = prevStep = !parent.children.isEmpty() ? parent.children.peekLast() : parent;
        if (prevStep.supplier != supplier) {
            return;
        }
        String prev = prevStep == parent ? prevStep.getPreStepContent() : prevStep.getPostStepContent();
        long l = start = prevStep == parent ? prevStep.getStartTime() : prevStep.getEndTime();
        if (prev == null) {
            return;
        }
        try {
            content = supplier.get();
        }
        catch (Throwable ignored) {
            return;
        }
        if (prev.equals(content)) {
            return;
        }
        parent.children.add(new Step(this, this.nextStepId(), "...", parent, prev, content, start, System.nanoTime()));
    }

    private void insertPostMicroStep(Step parent) {
        if (parent.children.isEmpty()) {
            return;
        }
        Step lastChild = parent.children.getLast();
        if (lastChild.getType() == Step.StepType.TIMING) {
            return;
        }
        if (parent.getPostStepContent() == null) {
            return;
        }
        if (parent.getStatus() == Step.Status.ERROR) {
            return;
        }
        String prev = lastChild.getPostStepContent();
        if (prev == null) {
            return;
        }
        if (parent.getPostStepContent().equals(lastChild.getPostStepContent())) {
            return;
        }
        parent.children.add(new Step(this, this.nextStepId(), "...", parent, prev, parent.getPostStepContent(), lastChild.getEndTime(), parent.getEndTime()));
    }

    @Override
    public void popTiming() {
        this.steps.pop().finish();
    }

    @Override
    public void except(Throwable e) {
        assert (this.exception == null);
        this.exception = e;
        SneakyUtils.throwUnchecked((Throwable)e);
    }

    @Override
    @Nullable
    public Step getRoot() {
        return this.root;
    }

    @Nullable
    Throwable clearExcept() {
        Throwable e = this.exception;
        this.exception = null;
        return e;
    }

    int nextStepId() {
        int id;
        if ((id = this.nextStepId++) == this.stopAtStep) {
            try {
                throw new DebugStopAtStep();
            }
            catch (DebugStopAtStep debugStopAtStep) {
                // empty catch block
            }
        }
        return id;
    }
}

