package net.covers1624.coffeegrinder.bytecode.transform;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import org.jetbrains.annotations.Nullable;

/**
 * Created by covers1624 on 21/7/21.
 */
public class StatementTransformContext extends MethodTransformContext {

    public final Block block;
    @Nullable
    private Instruction next;
    boolean skipRequested = false;

    public StatementTransformContext(MethodTransformContext other, Block block) {
        super(other);
        this.block = block;
        next = block.getLastChild();
    }

    /**
     * After the current statement transform has completed,
     * repeat all statement transforms on the current position.
     */
    public void requestRerun() {
        assert !skipRequested;
        skipRequested = true;
        next = current();
    }

    public Instruction current() {
        return next == null ? block.getFirstChild() : next.getNextSibling();
    }

    public boolean moveNext() {
        if (next == null) return false;
        assert next.getParent() == block;
        next = next.getPrevSiblingOrNull();
        return true;
    }
}
