/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.covers1624.coffeegrinder.DecompilerSettings;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.ReaderInvariantVisitor;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.VariableLivenessGraph;
import net.covers1624.coffeegrinder.bytecode.insns.ArrayElementReference;
import net.covers1624.coffeegrinder.bytecode.insns.ArrayLen;
import net.covers1624.coffeegrinder.bytecode.insns.Binary;
import net.covers1624.coffeegrinder.bytecode.insns.BinaryOp;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.Branch;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.Compare;
import net.covers1624.coffeegrinder.bytecode.insns.Comparison;
import net.covers1624.coffeegrinder.bytecode.insns.CompoundAssignment;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.IfInstruction;
import net.covers1624.coffeegrinder.bytecode.insns.InstanceOf;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.InvokeDynamic;
import net.covers1624.coffeegrinder.bytecode.insns.LdcClass;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNull;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNumber;
import net.covers1624.coffeegrinder.bytecode.insns.LdcString;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LoadThis;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.MonitorEnter;
import net.covers1624.coffeegrinder.bytecode.insns.MonitorExit;
import net.covers1624.coffeegrinder.bytecode.insns.NewArray;
import net.covers1624.coffeegrinder.bytecode.insns.NewObject;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.ParameterVariable;
import net.covers1624.coffeegrinder.bytecode.insns.Return;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.SwitchTable;
import net.covers1624.coffeegrinder.bytecode.insns.Throw;
import net.covers1624.coffeegrinder.bytecode.insns.TryCatch;
import net.covers1624.coffeegrinder.bytecode.insns.tags.IIncTag;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.debug.Debugger;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.AnnotationSupplier;
import net.covers1624.coffeegrinder.type.ArrayType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.Parameter;
import net.covers1624.coffeegrinder.type.ParameterizedClass;
import net.covers1624.coffeegrinder.type.PolymorphicSignatureMethod;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.type.asm.AsmMethod;
import net.covers1624.coffeegrinder.util.None;
import net.covers1624.coffeegrinder.util.OpcodeLookup;
import net.covers1624.coffeegrinder.util.Util;
import net.covers1624.coffeegrinder.util.asm.AsmUtils;
import net.covers1624.coffeegrinder.util.asm.NodeAwareMethodVisitor;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ConstantDynamic;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;
import org.objectweb.asm.tree.TryCatchBlockNode;

public class InstructionReader
extends NodeAwareMethodVisitor {
    private static final int[] I_CONST = new int[]{-1, 0, 1, 2, 3, 4, 5};
    private static final Type[] A_TYPES = new Type[]{Type.INT_TYPE, Type.LONG_TYPE, Type.FLOAT_TYPE, Type.DOUBLE_TYPE, TypeResolver.OBJECT_TYPE, Type.BYTE_TYPE, Type.CHAR_TYPE, Type.SHORT_TYPE};
    private static final Type[] ILFDA_TYPES = new Type[]{Type.INT_TYPE, Type.LONG_TYPE, Type.FLOAT_TYPE, Type.DOUBLE_TYPE, TypeResolver.OBJECT_TYPE};
    private static final Type[] NUMERIC_RESULTS = new Type[]{Type.INT_TYPE, Type.LONG_TYPE, Type.FLOAT_TYPE, Type.DOUBLE_TYPE, Type.INT_TYPE, Type.LONG_TYPE, Type.FLOAT_TYPE, Type.DOUBLE_TYPE, Type.INT_TYPE, Type.LONG_TYPE, Type.FLOAT_TYPE, Type.DOUBLE_TYPE, Type.INT_TYPE, Type.LONG_TYPE, Type.FLOAT_TYPE, Type.DOUBLE_TYPE, Type.INT_TYPE, Type.LONG_TYPE, Type.FLOAT_TYPE, Type.DOUBLE_TYPE, Type.INT_TYPE, Type.LONG_TYPE, Type.FLOAT_TYPE, Type.DOUBLE_TYPE, Type.INT_TYPE, Type.LONG_TYPE, Type.INT_TYPE, Type.LONG_TYPE, Type.INT_TYPE, Type.LONG_TYPE, Type.INT_TYPE, Type.LONG_TYPE, Type.INT_TYPE, Type.LONG_TYPE, Type.INT_TYPE, Type.LONG_TYPE};
    private static final BinaryOp[] NUMERIC_OPS = new BinaryOp[]{BinaryOp.ADD, BinaryOp.ADD, BinaryOp.ADD, BinaryOp.ADD, BinaryOp.SUB, BinaryOp.SUB, BinaryOp.SUB, BinaryOp.SUB, BinaryOp.MUL, BinaryOp.MUL, BinaryOp.MUL, BinaryOp.MUL, BinaryOp.DIV, BinaryOp.DIV, BinaryOp.DIV, BinaryOp.DIV, BinaryOp.REM, BinaryOp.REM, BinaryOp.REM, BinaryOp.REM, null, null, null, null, BinaryOp.SHIFT_LEFT, BinaryOp.SHIFT_LEFT, BinaryOp.SHIFT_RIGHT, BinaryOp.SHIFT_RIGHT, BinaryOp.LOGICAL_SHIFT_RIGHT, BinaryOp.LOGICAL_SHIFT_RIGHT, BinaryOp.AND, BinaryOp.AND, BinaryOp.OR, BinaryOp.OR, BinaryOp.XOR, BinaryOp.XOR};
    public static final Instruction[] NEG_LDC = new Instruction[]{new LdcNumber(0), new LdcNumber(0L), new LdcNumber(Float.valueOf(0.0f)), new LdcNumber(0.0)};
    public static final Type[][] PRIMITIVE_CAST = new Type[][]{{Type.INT_TYPE, Type.LONG_TYPE}, {Type.INT_TYPE, Type.FLOAT_TYPE}, {Type.INT_TYPE, Type.DOUBLE_TYPE}, {Type.LONG_TYPE, Type.INT_TYPE}, {Type.LONG_TYPE, Type.FLOAT_TYPE}, {Type.LONG_TYPE, Type.DOUBLE_TYPE}, {Type.FLOAT_TYPE, Type.INT_TYPE}, {Type.FLOAT_TYPE, Type.LONG_TYPE}, {Type.FLOAT_TYPE, Type.DOUBLE_TYPE}, {Type.DOUBLE_TYPE, Type.INT_TYPE}, {Type.DOUBLE_TYPE, Type.LONG_TYPE}, {Type.DOUBLE_TYPE, Type.FLOAT_TYPE}, {Type.INT_TYPE, Type.BYTE_TYPE}, {Type.INT_TYPE, Type.CHAR_TYPE}, {Type.INT_TYPE, Type.SHORT_TYPE}};
    public static final Type[] COMPARISONS = new Type[]{Type.LONG_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE};
    public static final Compare.Kind[] CMP_EXT_KINDS = new Compare.Kind[]{Compare.Kind.LONG, Compare.Kind.NAN_L, Compare.Kind.NAN_G, Compare.Kind.NAN_L, Compare.Kind.NAN_G};
    public static final Comparison.ComparisonKind[] IF_CMP_KINDS = new Comparison.ComparisonKind[]{Comparison.ComparisonKind.EQUAL, Comparison.ComparisonKind.NOT_EQUAL, Comparison.ComparisonKind.LESS_THAN, Comparison.ComparisonKind.GREATER_THAN_EQUAL, Comparison.ComparisonKind.GREATER_THAN, Comparison.ComparisonKind.LESS_THAN_EQUAL, Comparison.ComparisonKind.EQUAL, Comparison.ComparisonKind.NOT_EQUAL, Comparison.ComparisonKind.LESS_THAN, Comparison.ComparisonKind.GREATER_THAN_EQUAL, Comparison.ComparisonKind.GREATER_THAN, Comparison.ComparisonKind.LESS_THAN_EQUAL, Comparison.ComparisonKind.EQUAL, Comparison.ComparisonKind.NOT_EQUAL};
    public static final Type[] T_TYPES = new Type[]{Type.BOOLEAN_TYPE, Type.CHAR_TYPE, Type.FLOAT_TYPE, Type.DOUBLE_TYPE, Type.BYTE_TYPE, Type.SHORT_TYPE, Type.INT_TYPE, Type.LONG_TYPE};
    public static final Invoke.InvokeKind[] INVOKE_KINDS = new Invoke.InvokeKind[]{Invoke.InvokeKind.VIRTUAL, Invoke.InvokeKind.SPECIAL, Invoke.InvokeKind.STATIC, Invoke.InvokeKind.INTERFACE};
    private final TypeResolver typeResolver;
    private final Method method;
    private final MethodNode mNode;
    private final int firstLocalIndex;
    private final ParameterVariable[] parameterVariables;
    private final List<ParameterVariable> paramVariablesList;
    private final MethodDecl function;
    private final BlockContainer mainContainer;
    @Nullable
    private final Label labelAfterCode;
    private final Object2IntMap<Label> importantLabels;
    private final Map<TryCatchBlockNode, TryCatch> tryCatches;
    private final Map<Label, Block> blockMap = new HashMap<Label, Block>();
    private final Supplier<ClassType> thisType;
    private BlockContainer currentContainer;
    @Nullable
    private Block currentBlock;
    private int stackVarCounter;
    private final LinkedList<LocalVariable> currentStack = new LinkedList();
    private final LinkedList<LocalVariableNode> activeLVNodes = new LinkedList();
    private final VariableLivenessGraph vlGraph;
    private int currentIndex;
    private int sourceLineNumber = -1;
    private int variableCounter = 0;

    private InstructionReader(TypeResolver typeResolver, Method method) {
        super(458752);
        this.typeResolver = typeResolver;
        this.method = method;
        this.mNode = ((AsmMethod)method).getNode();
        this.firstLocalIndex = AsmUtils.getFirstLocalIndex(this.mNode);
        this.parameterVariables = this.computeParameters();
        this.paramVariablesList = FastStream.of((Object[])this.parameterVariables).filter(Objects::nonNull).toImmutableList();
        this.currentContainer = this.mainContainer = new BlockContainer();
        this.function = new MethodDecl(method, this.mainContainer, this.paramVariablesList);
        this.function.setReturnType(method.asRaw().getReturnType());
        this.function.addRef();
        AbstractInsnNode last = this.mNode.instructions.getLast();
        this.labelAfterCode = last instanceof LabelNode ? ((LabelNode)last).getLabel() : null;
        this.importantLabels = InstructionReader.computeImportantLabels(this.mNode);
        this.vlGraph = new VariableLivenessGraph(this.mNode.maxLocals, this.firstLocalIndex, this.getBlock(Objects.requireNonNull(InstructionReader.getFirstLabel(this.mNode))));
        this.tryCatches = this.generateTryCatchInsns(this.mNode.tryCatchBlocks);
        this.thisType = Util.singleMemoize(() -> TypeSystem.makeThisType(method.getDeclaringClass()));
    }

    private Map<TryCatchBlockNode, TryCatch> generateTryCatchInsns(List<TryCatchBlockNode> tryCatchBlocks) {
        HashMap handlerMap = new HashMap();
        AtomicInteger i = new AtomicInteger();
        return FastStream.of(tryCatchBlocks).toMap(Function.identity(), tcBlock -> {
            LocalVariable variable = new LocalVariable(LocalVariable.VariableKind.STACK_SLOT, this.typeResolver.resolveType(tcBlock.type == null ? TypeResolver.THROWABLE_TYPE : Type.getObjectType((String)tcBlock.type)), "e_" + i.getAndIncrement());
            Label handler = tcBlock.handler.getLabel();
            TryCatch tryCatch = handlerMap.computeIfAbsent(handler, x -> this.createTryCatch((Label)x, variable, tcBlock.type == null));
            LocalVariable var = ((TryCatch.TryCatchHandler)tryCatch.handlers.only()).getVariable().variable;
            if (var == variable) {
                this.function.variables.add(variable);
            } else {
                var.setType(TypeSystem.makeMultiCatchUnion((ReferenceType)var.getType(), (ReferenceType)variable.getType()));
            }
            this.vlGraph.addExceptionHandler(this.getBlock(handler), var);
            return tryCatch;
        });
    }

    @NotNull
    private TryCatch createTryCatch(Label handler, LocalVariable variable, boolean isFinally) {
        TryCatch tc = new TryCatch(new BlockContainer());
        BlockContainer handlerBody = new BlockContainer();
        Block handlerBlock = new Block();
        handlerBlock.instructions.add(new Branch(this.getBlock(handler)));
        handlerBody.blocks.add(handlerBlock);
        TryCatch.TryCatchHandler tcHandler = new TryCatch.TryCatchHandler(handlerBody, new LocalReference(variable));
        if (isFinally) {
            tcHandler.isUnprocessedFinally = true;
        }
        tc.handlers.add(tcHandler);
        return tc;
    }

    private ParameterVariable[] computeParameters() {
        ParameterVariable[] parameterVariables = new ParameterVariable[this.firstLocalIndex];
        int lIndex = !this.method.isStatic() ? 1 : 0;
        int pIndex = 0;
        for (Parameter parameter : this.method.getParameters()) {
            ParameterVariable pVar = this.getParameterVariable(parameter, lIndex, pIndex++);
            parameterVariables[lIndex++] = pVar;
            if (parameter.getRawType() != PrimitiveType.LONG && parameter.getRawType() != PrimitiveType.DOUBLE) continue;
            parameterVariables[lIndex++] = null;
        }
        return parameterVariables;
    }

    private ParameterVariable getParameterVariable(Parameter parameter, int index, int pIndex) {
        LocalVariableNode found = null;
        if (this.mNode.localVariables != null) {
            for (LocalVariableNode lv : this.mNode.localVariables) {
                if (lv.index != index) continue;
                assert (found == null) : "Found duplicate LocalVariableNode for parameter index " + index;
                found = lv;
            }
        }
        assert (found == null || parameter.getRawType().equals(this.typeResolver.resolveType(Type.getType((String)found.desc))));
        return new ParameterVariable(parameter, parameter.getRawType(), found != null ? found.signature : null, index, (String)(found != null ? found.name : "par_" + index), pIndex);
    }

    private LocalVariable getStoreLocal(int index, AType storingType) {
        if (index < this.firstLocalIndex) {
            return Objects.requireNonNull(this.parameterVariables[index]);
        }
        LocalVariable var = new LocalVariable(LocalVariable.VariableKind.LOCAL, storingType, null, index, "var_" + this.variableCounter++);
        this.function.variables.add(var);
        var.setSynthetic(true);
        return var;
    }

    private LocalReference getLoadLocal(int index) {
        if (index < this.firstLocalIndex) {
            return new LocalReference(Objects.requireNonNull(this.parameterVariables[index]));
        }
        return this.vlGraph.readLocal(index);
    }

    private Block getBlock(Label label) {
        return this.blockMap.computeIfAbsent(label, e -> new Block(this.getBlockName((Label)e)));
    }

    private String getBlockName(Label label) {
        int index = this.importantLabels.getOrDefault((Object)label, -1);
        if (index != -1) {
            return "L" + index;
        }
        String name = Objects.requireNonNull(this.currentBlock).getName();
        int lastUnderscore = name.lastIndexOf("_");
        if (lastUnderscore != -1) {
            String num = name.substring(lastUnderscore + 1);
            try {
                return name.substring(0, lastUnderscore + 1) + (Integer.parseInt(num) + 1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.currentBlock.getSubName("1");
    }

    public static MethodDecl parse(TypeResolver typeResolver, Method method) {
        if (method.isAbstract()) {
            int index = 0;
            LinkedList<ParameterVariable> parameters = new LinkedList<ParameterVariable>();
            for (Parameter parameter : method.getParameters()) {
                parameters.add(new ParameterVariable(parameter, parameter.getType(), null, index, parameter.getName(), index++));
            }
            MethodDecl func = new MethodDecl(method, new Nop(), parameters);
            func.addRef();
            return func;
        }
        InstructionReader reader = new InstructionReader(typeResolver, method);
        reader.mNode.accept((MethodVisitor)reader);
        HashSet parameterNames = DecompilerSettings.ASSERTIONS_ENABLED ? FastStream.of(reader.paramVariablesList).map(LocalVariable::getName).toSet() : Collections.emptySet();
        Object2IntOpenHashMap variableNameUsages = new Object2IntOpenHashMap();
        Iterator<LocalVariable> iterator = reader.function.variables.iterator();
        while (iterator.hasNext()) {
            LocalVariable v = iterator.next();
            if (v.getKind() != LocalVariable.VariableKind.LOCAL) continue;
            assert (!parameterNames.contains(v.getName()));
            v.setSubId(variableNameUsages.computeInt((Object)v.getName(), (s, i) -> i == null ? 0 : i + 1));
        }
        return reader.function;
    }

    private void evalDumpGraph() {
        this.evalDumpGraph("eval_graph");
    }

    private void evalDumpGraph(String name) {
        Debugger.tryIfPresent((SneakyUtils.ThrowingConsumer<Debugger, Throwable>)((SneakyUtils.ThrowingConsumer)e -> e.writeVariableLivenessGraph(this.vlGraph, Paths.get("./graphs/" + name + ".png", new String[0]))));
    }

    private Instruction push(Instruction insn, Type expectedStackType) {
        this.assertStackType(insn, expectedStackType);
        return this.pushUnchecked(insn);
    }

    private Instruction pushUnchecked(Instruction insn) {
        LocalVariable v = new LocalVariable(LocalVariable.VariableKind.STACK_SLOT, insn.getResultType(), "s_" + this.stackVarCounter++);
        this.currentStack.push(v);
        this.function.variables.add(v);
        return new Store(new LocalReference(v), insn);
    }

    private Instruction pop() {
        if (this.currentStack.isEmpty()) {
            throw new RuntimeException("Stack underflow.");
        }
        return new Load(new LocalReference(this.currentStack.pop()));
    }

    private List<Instruction> popMany(int num) {
        Instruction[] insns = new Instruction[num];
        for (int i = num - 1; i >= 0; --i) {
            insns[i] = this.pop();
        }
        return List.of(insns);
    }

    private void addInsn(Instruction insn) {
        assert (this.currentBlock != null);
        this.currentBlock.instructions.add(insn);
        insn.getDescendants().forEach(e -> {
            e.setBytecodeOffset(this.currentIndex);
            e.setSourceLine(this.sourceLineNumber);
        });
        if (DecompilerSettings.ASSERTIONS_ENABLED) {
            insn.accept(new ReaderInvariantVisitor());
        }
        insn.descendantsOfType(Branch.class).forEach(b -> {
            this.vlGraph.addCFEdge(b.getTargetBlock(), this.currentStack);
            this.adjustBranchTarget((Branch)b);
        });
        if (insn.getFlags().get(InstructionFlag.END_POINT_UNREACHABLE)) {
            this.currentStack.clear();
            this.currentBlock = null;
        } else if (insn.getFlags().get(InstructionFlag.MAY_BRANCH)) {
            this.visitImportantLabel(new Label());
        }
        Store store = LoadStoreMatching.matchStoreLocal(insn);
        if (store != null && store.getVariable().getKind() == LocalVariable.VariableKind.LOCAL) {
            this.vlGraph.visitStore(store);
            LocalVariableNode lv = (LocalVariableNode)FastStream.of(this.activeLVNodes).filter(n -> n.index == store.getVariable().getIndex()).onlyOrDefault();
            if (lv != null) {
                this.applyLVInfo(lv);
            }
        }
        for (TryCatch tryCatch : this.currentContainer.ancestorsOfType(TryCatch.class)) {
            this.vlGraph.addExceptionLink(InstructionReader.getHandlerBlock(tryCatch));
        }
    }

    private void adjustBranchTarget(Branch b) {
        while (b.isDescendantOf(b.getTargetBlock()) && b.getTargetBlock() != this.currentBlock) {
            TryCatch tryCatch = (TryCatch)b.getTargetBlock().getFirstChild();
            b.setTargetBlock(tryCatch.getTryBody().getEntryPoint());
        }
    }

    public void visitEnd() {
        this.vlGraph.applyAllReplacements(this.mainContainer);
        this.fixupOverlappingTryCatchHandlers();
    }

    private void fixupOverlappingTryCatchHandlers() {
        this.mainContainer.accept(new SimpleInsnVisitor<None>(this){

            @Override
            public None visitTryCatch(TryCatch tryCatch, None ctx) {
                Block handler = InstructionReader.getHandlerBlock(tryCatch);
                if (handler.isDescendantOf(tryCatch)) {
                    tryCatch.getParent().insertAfter(handler);
                }
                return (None)super.visitTryCatch(tryCatch, ctx);
            }
        });
    }

    @Override
    public void visitInsn(AbstractInsnNode node, int index) {
        this.currentIndex = index;
        if (this.currentBlock != null || node.getType() == 8) {
            super.visitInsn(node, index);
        }
    }

    public void visitInsn(int opcode) {
        String insnName = OpcodeLookup.getName(opcode);
        switch (opcode) {
            case 0: {
                break;
            }
            case 1: {
                this.addInsn(this.push(new LdcNull(), TypeResolver.OBJECT_TYPE));
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.addInsn(this.push(new LdcNumber(I_CONST[opcode - 2]), Type.INT_TYPE));
                break;
            }
            case 9: {
                this.addInsn(this.push(new LdcNumber(0L), Type.LONG_TYPE));
                break;
            }
            case 10: {
                this.addInsn(this.push(new LdcNumber(1L), Type.LONG_TYPE));
                break;
            }
            case 11: {
                this.addInsn(this.push(new LdcNumber(Float.valueOf(0.0f)), Type.FLOAT_TYPE));
                break;
            }
            case 12: {
                this.addInsn(this.push(new LdcNumber(Float.valueOf(1.0f)), Type.FLOAT_TYPE));
                break;
            }
            case 13: {
                this.addInsn(this.push(new LdcNumber(Float.valueOf(2.0f)), Type.FLOAT_TYPE));
                break;
            }
            case 14: {
                this.addInsn(this.push(new LdcNumber(0.0), Type.DOUBLE_TYPE));
                break;
            }
            case 15: {
                this.addInsn(this.push(new LdcNumber(1.0), Type.DOUBLE_TYPE));
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                Instruction index = this.pop();
                Instruction array = this.pop();
                this.addInsn(this.push(new Load(new ArrayElementReference(array, index)), A_TYPES[opcode - 46]));
                break;
            }
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                Instruction value = this.pop();
                Instruction index = this.pop();
                Instruction array = this.pop();
                this.assertStackType(value, A_TYPES[opcode - 79]);
                this.addInsn(new Store(new ArrayElementReference(array, index), value));
                break;
            }
            case 87: {
                LocalVariable v = this.currentStack.pop();
                assert (!this.isWide(v));
                break;
            }
            case 88: {
                if (this.isWide(this.currentStack.pop())) break;
                LocalVariable second = this.currentStack.pop();
                assert (!this.isWide(second));
                break;
            }
            case 89: {
                this.currentStack.push(this.currentStack.peek());
                break;
            }
            case 90: {
                LocalVariable v1 = this.currentStack.pop();
                LocalVariable v2 = this.currentStack.pop();
                assert (!this.isWide(v1));
                assert (!this.isWide(v2));
                this.currentStack.push(v1);
                this.currentStack.push(v2);
                this.currentStack.push(v1);
                break;
            }
            case 91: {
                LocalVariable v1 = this.currentStack.pop();
                LocalVariable v2 = this.currentStack.pop();
                if (this.isWide(v2)) {
                    assert (!this.isWide(v1));
                    assert (this.isWide(v2));
                    this.currentStack.push(v1);
                    this.currentStack.push(v2);
                    this.currentStack.push(v1);
                    break;
                }
                LocalVariable v3 = this.currentStack.pop();
                assert (!this.isWide(v1));
                assert (!this.isWide(v2));
                assert (!this.isWide(v3));
                this.currentStack.push(v1);
                this.currentStack.push(v3);
                this.currentStack.push(v2);
                this.currentStack.push(v1);
                break;
            }
            case 92: {
                LocalVariable v1 = this.currentStack.pop();
                if (this.isWide(v1)) {
                    assert (this.isWide(v1));
                    this.currentStack.push(v1);
                    this.currentStack.push(v1);
                    break;
                }
                LocalVariable v2 = this.currentStack.pop();
                assert (!this.isWide(v1));
                assert (!this.isWide(v2));
                this.currentStack.push(v2);
                this.currentStack.push(v1);
                this.currentStack.push(v2);
                this.currentStack.push(v1);
                break;
            }
            case 93: {
                LocalVariable v1 = this.currentStack.pop();
                LocalVariable v2 = this.currentStack.pop();
                if (this.isWide(v1)) {
                    assert (this.isWide(v1));
                    assert (!this.isWide(v2));
                    this.currentStack.push(v1);
                    this.currentStack.push(v2);
                    this.currentStack.push(v1);
                    break;
                }
                LocalVariable v3 = this.currentStack.pop();
                assert (!this.isWide(v1));
                assert (!this.isWide(v2));
                assert (!this.isWide(v3));
                this.currentStack.push(v2);
                this.currentStack.push(v1);
                this.currentStack.push(v3);
                this.currentStack.push(v2);
                this.currentStack.push(v1);
                break;
            }
            case 94: {
                LocalVariable v1 = this.currentStack.pop();
                LocalVariable v2 = this.currentStack.pop();
                if (!this.isWide(v1)) {
                    assert (!this.isWide(v2));
                    LocalVariable v3 = this.currentStack.pop();
                    if (this.isWide(v3)) {
                        assert (!this.isWide(v1));
                        assert (!this.isWide(v2));
                        assert (this.isWide(v3));
                        this.currentStack.push(v2);
                        this.currentStack.push(v1);
                        this.currentStack.push(v3);
                        this.currentStack.push(v2);
                        this.currentStack.push(v1);
                        break;
                    }
                    LocalVariable v4 = this.currentStack.pop();
                    assert (!this.isWide(v1));
                    assert (!this.isWide(v2));
                    assert (!this.isWide(v3));
                    assert (!this.isWide(v4));
                    this.currentStack.push(v2);
                    this.currentStack.push(v1);
                    this.currentStack.push(v4);
                    this.currentStack.push(v3);
                    this.currentStack.push(v2);
                    this.currentStack.push(v1);
                    break;
                }
                if (this.isWide(v2)) {
                    assert (this.isWide(v1));
                    assert (this.isWide(v2));
                    this.currentStack.push(v1);
                    this.currentStack.push(v2);
                    this.currentStack.push(v1);
                    break;
                }
                LocalVariable v3 = this.currentStack.pop();
                assert (this.isWide(v1));
                assert (!this.isWide(v2));
                assert (!this.isWide(v3));
                this.currentStack.push(v1);
                this.currentStack.push(v3);
                this.currentStack.push(v2);
                this.currentStack.push(v1);
                break;
            }
            case 95: {
                LocalVariable v1 = this.currentStack.pop();
                LocalVariable v2 = this.currentStack.pop();
                this.currentStack.push(v1);
                this.currentStack.push(v2);
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: {
                Instruction right = this.pop();
                Instruction left = this.pop();
                Type result = NUMERIC_RESULTS[opcode - 96];
                BinaryOp op = Objects.requireNonNull(NUMERIC_OPS[opcode - 96]);
                this.assertStackType(left, result);
                this.assertStackType(right, result);
                this.addInsn(this.push(new Binary(op, left, right), result));
                break;
            }
            case 116: 
            case 117: 
            case 118: 
            case 119: {
                Type result = NUMERIC_RESULTS[opcode - 96];
                Instruction right = this.pop();
                Instruction left = NEG_LDC[opcode - 116].copy();
                this.assertStackType(left, result);
                this.assertStackType(right, result);
                this.addInsn(this.push(new Binary(BinaryOp.SUB, left, right), result));
                break;
            }
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: {
                Type[] types = PRIMITIVE_CAST[opcode - 133];
                Instruction value = this.pop();
                this.assertStackType(value, types[0]);
                this.addInsn(this.push(new Cast(value, this.typeResolver.resolveType(types[1])), types[1]));
                break;
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                Type expectedType = COMPARISONS[opcode - 148];
                Instruction right = this.pop();
                Instruction left = this.pop();
                this.assertStackType(left, expectedType);
                this.assertStackType(right, expectedType);
                this.addInsn(this.push(new Compare(CMP_EXT_KINDS[opcode - 148], left, right), Type.INT_TYPE));
                break;
            }
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: {
                this.vlGraph.markNode("Return");
                assert (this.currentStack.size() == 1);
                Instruction arg = this.pop();
                this.addInsn(new Return(this.function, arg));
                break;
            }
            case 177: {
                this.vlGraph.markNode("Return");
                assert (this.currentStack.isEmpty());
                this.addInsn(new Return(this.function));
                break;
            }
            case 190: {
                this.addInsn(this.push(new ArrayLen(this.pop()), Type.INT_TYPE));
                break;
            }
            case 191: {
                this.vlGraph.markNode("Throw");
                this.addInsn(new Throw(this.pop()));
                break;
            }
            case 194: {
                this.addInsn(new MonitorEnter(this.pop()));
                break;
            }
            case 195: {
                this.addInsn(new MonitorExit(this.pop()));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled insn: " + insnName);
            }
        }
    }

    public void visitIntInsn(int opcode, int operand) {
        block0 : switch (opcode) {
            case 16: {
                this.addInsn(this.push(new LdcNumber(operand), Type.BYTE_TYPE));
                break;
            }
            case 17: {
                this.addInsn(this.push(new LdcNumber(operand), Type.SHORT_TYPE));
                break;
            }
            case 188: {
                switch (operand) {
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: {
                        Instruction size = this.pop();
                        this.assertStackType(size, Type.INT_TYPE);
                        this.addInsn(this.push(new NewArray((ArrayType)this.typeResolver.resolveType(Type.getType((String)("[" + String.valueOf(T_TYPES[operand - 4])))), false, size), TypeResolver.OBJECT_TYPE));
                        break block0;
                    }
                }
                throw new IllegalArgumentException("Unexpected NEWARRAY operand: " + operand);
            }
            default: {
                throw new IllegalArgumentException("Unhandled int insn: " + OpcodeLookup.getName(opcode));
            }
        }
    }

    public void visitVarInsn(int opcode, int var) {
        switch (opcode) {
            case 25: {
                if ((this.mNode.access & 8) == 0 && var == 0) {
                    this.addInsn(this.push(new LoadThis(this.thisType.get()), TypeResolver.OBJECT_TYPE));
                    break;
                }
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                Type expectedType = ILFDA_TYPES[opcode - 21];
                this.addInsn(this.push(new Load(this.getLoadLocal(var)), expectedType));
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                Instruction arg = this.pop();
                LocalVariable variable = this.getStoreLocal(var, arg.getResultType());
                this.addInsn(new Store(new LocalReference(variable), arg));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled var insn: " + OpcodeLookup.getName(opcode));
            }
            case 169: {
                throw new IllegalArgumentException("Legacy RET instruction not currently supported.");
            }
        }
    }

    public void visitTypeInsn(int opcode, String typeDesc) {
        Type elementType = Type.getObjectType((String)typeDesc);
        AType type = this.typeResolver.resolveType(Type.getObjectType((String)typeDesc));
        switch (opcode) {
            case 187: {
                this.addInsn(this.push(new NewObject(type), TypeResolver.OBJECT_TYPE));
                break;
            }
            case 189: {
                Instruction size = this.pop();
                this.assertStackType(size, Type.INT_TYPE);
                ArrayType arrayType = (ArrayType)this.typeResolver.resolveType(Type.getType((String)("[" + elementType.getDescriptor())));
                this.addInsn(this.push(new NewArray(arrayType, false, size), TypeResolver.OBJECT_TYPE));
                break;
            }
            case 192: {
                Instruction arg = this.pop();
                this.assertStackType(arg, TypeResolver.OBJECT_TYPE);
                if (!TypeSystem.isCastableTo((ReferenceType)arg.getResultType(), (ReferenceType)type, true)) {
                    arg = new Cast(arg, this.typeResolver.resolveReferenceType(TypeResolver.OBJECT_TYPE));
                }
                this.addInsn(this.push(new Cast(arg, type), TypeResolver.OBJECT_TYPE));
                break;
            }
            case 193: {
                Instruction arg = this.pop();
                this.assertStackType(arg, TypeResolver.OBJECT_TYPE);
                this.addInsn(this.push(new InstanceOf(arg, type), Type.BOOLEAN_TYPE));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled type insn: " + OpcodeLookup.getName(opcode));
            }
        }
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        ClassType clazz = this.typeResolver.resolveClassDecl(owner);
        Type desc = Type.getType((String)descriptor);
        Field field = Objects.requireNonNull(clazz.resolveField(name, desc), "Failed to resolve field " + owner + "." + name + " " + descriptor).asRaw();
        switch (opcode) {
            case 178: {
                this.addInsn(this.pushUnchecked(new Load(new FieldReference(clazz, field, new Nop()))));
                break;
            }
            case 179: {
                Instruction value = this.pop();
                this.addInsn(new Store(new FieldReference(clazz, field, new Nop()), value));
                break;
            }
            case 180: {
                this.addInsn(this.pushUnchecked(new Load(new FieldReference(clazz, field, this.pop()))));
                break;
            }
            case 181: {
                Instruction value = this.pop();
                Instruction target = this.pop();
                this.addInsn(new Store(new FieldReference(clazz, field, target), value));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled field insn: " + OpcodeLookup.getName(opcode));
            }
        }
    }

    public void visitMethodInsn(int opcode, String ownerName, String name, String descriptor, boolean isInterface) {
        ReferenceType owner = (ReferenceType)this.typeResolver.resolveTypeDecl(Type.getObjectType((String)ownerName));
        Type methodDesc = Type.getMethodType((String)descriptor);
        Method method = Objects.requireNonNull(owner.resolveMethod(name, methodDesc), "Failed to resolve method " + ownerName + "." + name + descriptor).asRaw();
        ClassType targetClassType = owner instanceof ClassType ? (ClassType)owner : method.getDeclaringClass();
        List<Instruction> args = this.popMany(methodDesc.getArgumentTypes().length);
        switch (opcode) {
            case 182: 
            case 183: 
            case 185: {
                Instruction target = this.pop();
                Instruction invoke = new Invoke(INVOKE_KINDS[opcode - 182], targetClassType, method, target, args);
                AType result = ((Instruction)invoke).getResultType();
                Type retType = methodDesc.getReturnType();
                if (result != PrimitiveType.VOID && retType != Type.VOID_TYPE) {
                    if (method instanceof PolymorphicSignatureMethod && !retType.equals((Object)TypeResolver.OBJECT_TYPE)) {
                        invoke = new Cast(invoke, this.typeResolver.resolveType(retType));
                    }
                    invoke = this.push(invoke, retType);
                }
                this.addInsn(invoke);
                break;
            }
            case 184: {
                Instruction invoke = new Invoke(INVOKE_KINDS[opcode - 182], targetClassType, method, new Nop(), args);
                if (((Instruction)invoke).getResultType() != PrimitiveType.VOID) {
                    invoke = this.push(invoke, methodDesc.getReturnType());
                }
                this.addInsn(invoke);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled method insn: " + OpcodeLookup.getName(opcode));
            }
        }
    }

    public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
        Type retType = Type.getReturnType((String)descriptor);
        InvokeDynamic invoke = new InvokeDynamic(this.typeResolver.resolveType(retType), name, (Method)this.parseHandle(bootstrapMethodHandle), FastStream.of((Object[])bootstrapMethodArguments).map(this::parseBootstrapArgument).toArray(), this.popMany(Type.getArgumentTypes((String)descriptor).length));
        this.addInsn(this.push(invoke, retType));
    }

    private Object parseBootstrapArgument(Object obj) {
        if (obj instanceof ConstantDynamic) {
            throw new UnsupportedOperationException("ConstantDynamic not supported yet.");
        }
        if (obj instanceof Handle) {
            return this.parseHandle((Handle)obj);
        }
        return obj;
    }

    private Object parseHandle(Handle handle) {
        ClassType clazz = this.typeResolver.resolveClassDecl(handle.getOwner());
        if (handle.getTag() <= 4) {
            return Objects.requireNonNull(clazz.resolveField(handle.getName(), Type.getType((String)handle.getDesc())), "Failed to resolve field handle." + String.valueOf(handle)).asRaw();
        }
        return Objects.requireNonNull(clazz.resolveMethod(handle.getName(), Type.getMethodType((String)handle.getDesc())), "Failed to resolve method handle. " + String.valueOf(handle)).asRaw();
    }

    public void visitJumpInsn(int opcode, Label label) {
        Block target = this.getBlock(label);
        this.addInsn(switch (opcode) {
            case 153, 154, 155, 156, 157, 158 -> {
                Comparison comparison = new Comparison(IF_CMP_KINDS[opcode - 153], this.pop(), new LdcNumber(0));
                yield new IfInstruction(comparison, new Branch(target));
            }
            case 159, 160, 161, 162, 163, 164, 165, 166 -> {
                Instruction right = this.pop();
                Instruction left = this.pop();
                Comparison comparison = new Comparison(IF_CMP_KINDS[opcode - 153], left, right);
                yield new IfInstruction(comparison, new Branch(target));
            }
            case 167 -> new Branch(target);
            case 198, 199 -> {
                Comparison.ComparisonKind kind = opcode == 198 ? Comparison.ComparisonKind.EQUAL : Comparison.ComparisonKind.NOT_EQUAL;
                Comparison comparison = new Comparison(kind, this.pop(), new LdcNull());
                yield new IfInstruction(comparison, new Branch(target));
            }
            default -> throw new IllegalArgumentException("Unhandled int insn: " + OpcodeLookup.getName(opcode));
            case 168 -> throw new IllegalArgumentException("Legacy JSR instruction not currently supported.");
        });
    }

    public void visitLabel(Label label) {
        this.activeLVNodes.removeIf(n -> n.end.getLabel() == label);
        if (this.importantLabels.containsKey((Object)label)) {
            this.visitImportantLabel(label);
        }
        if (this.currentBlock == null) {
            return;
        }
        FastStream.of((Iterable)this.mNode.localVariables).filter(n -> n.start.getLabel() == label).forEach(this.activeLVNodes::add);
        for (LocalVariableNode lv : this.activeLVNodes) {
            this.applyLVInfo(lv);
        }
    }

    public void visitImportantLabel(Label label) {
        Block block = this.getBlock(label);
        if (this.currentBlock != null) {
            this.addInsn(new Branch(block));
        }
        if (label == this.labelAfterCode || this.vlGraph.isDead(block)) {
            return;
        }
        assert (this.currentStack.isEmpty());
        this.currentStack.addAll(this.vlGraph.visitBlock(block));
        FastStream.of((Iterable)this.mNode.tryCatchBlocks).filter(tcNode -> tcNode.end.getLabel() == label).map(this.tryCatches::get).distinct().forEach(tc -> {
            assert (tc == this.currentContainer.getParent());
            this.currentContainer = (BlockContainer)tc.getParent().getParent();
        });
        this.currentBlock = block;
        block.setBytecodeOffset(this.currentIndex);
        this.currentContainer.blocks.add(block);
        FastStream.of((Iterable)this.mNode.tryCatchBlocks).reversed().filter(tcNode -> tcNode.start.getLabel() == label).map(this.tryCatches::get).distinct().forEach(tryCatch -> {
            this.vlGraph.addHandlerLink(InstructionReader.getHandlerBlock(tryCatch));
            if (tryCatch.getParentOrNull() == null) {
                assert (tryCatch.getTryBody().blocks.isEmpty());
                this.currentBlock.instructions.add((Instruction)tryCatch);
                tryCatch.setBytecodeOffset(this.currentIndex);
                this.currentBlock = (Block)new Block(this.currentBlock.getSubName("try")).withOffsets(this.currentBlock);
            } else assert (this.currentContainer == tryCatch.getParent().getParent());
            this.currentContainer = tryCatch.getTryBody();
            this.currentContainer.blocks.add(this.currentBlock);
        });
    }

    private void applyLVInfo(LocalVariableNode lv) {
        if (lv.index < this.firstLocalIndex) {
            return;
        }
        Type lvDesc = Type.getType((String)lv.desc);
        LocalVariable variable = new LocalVariable(LocalVariable.VariableKind.LOCAL, this.typeResolver.resolveType(lvDesc), lv.signature, lv.index, lv.name);
        variable.setAnnotationSupplier(new AnnotationSupplier(this.typeResolver, (Iterable<AnnotationNode>)FastStream.of(), FastStream.of(Util.safeConcat(this.mNode.visibleLocalVariableAnnotations, this.mNode.invisibleLocalVariableAnnotations)).filter(e -> e.index.contains(lv.index) && e.start.contains(lv.start) && e.end.contains(lv.end)).toList(FastStream.infer())));
        this.vlGraph.applyLVInfo(variable);
    }

    public void visitLdcInsn(Object value) {
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Float.class, Long.class, Double.class, String.class, Type.class, Handle.class, ConstantDynamic.class}, (Object)object2, n)) {
            case 0: {
                Integer i = (Integer)object2;
                this.addInsn(this.push(new LdcNumber(i), Type.INT_TYPE));
                break;
            }
            case 1: {
                Float v = (Float)object2;
                this.addInsn(this.push(new LdcNumber(v), Type.FLOAT_TYPE));
                break;
            }
            case 2: {
                Long l = (Long)object2;
                this.addInsn(this.push(new LdcNumber(l), Type.LONG_TYPE));
                break;
            }
            case 3: {
                Double v = (Double)object2;
                this.addInsn(this.push(new LdcNumber(v), Type.DOUBLE_TYPE));
                break;
            }
            case 4: {
                String s = (String)object2;
                this.addInsn(this.push(new LdcString(this.typeResolver.resolveClass(TypeResolver.STRING_TYPE), s), TypeResolver.OBJECT_TYPE));
                break;
            }
            case 5: {
                Type type = (Type)object2;
                int sort = type.getSort();
                if (sort == 10 || sort == 9) {
                    ReferenceType ldcType = (ReferenceType)this.typeResolver.resolveType(type);
                    ClassType classClass = this.typeResolver.resolveClassDecl(TypeResolver.CLASS_TYPE);
                    this.addInsn(this.push(new LdcClass(ldcType, new ParameterizedClass(null, classClass, List.of(ldcType))), TypeResolver.OBJECT_TYPE));
                    break;
                }
                if (sort == 11) {
                    throw new UnsupportedOperationException("Not yet implemented.");
                }
                throw new IllegalArgumentException("Unhandled LDC Type " + sort);
            }
            case 6: {
                Handle handle = (Handle)object2;
                throw new UnsupportedOperationException("Not yet implemented.");
            }
            case 7: {
                ConstantDynamic constantDynamic = (ConstantDynamic)object2;
                throw new UnsupportedOperationException("Not yet implemented.");
            }
            default: {
                throw new IllegalArgumentException("Unknown LDC object " + value.getClass().getName());
            }
        }
    }

    public void visitIincInsn(int var, int increment) {
        CompoundAssignment iinc = new CompoundAssignment(increment < 0 ? BinaryOp.SUB : BinaryOp.ADD, this.getLoadLocal(var), new LdcNumber(Math.abs(increment)));
        iinc.setTag(new IIncTag());
        this.addInsn(iinc);
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        assert (max - min + 1 == labels.length);
        this.visitLookupSwitchInsn(dflt, IntStream.range(min, max + 1).toArray(), labels);
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        assert (keys.length == labels.length);
        Instruction value = this.pop();
        this.assertStackType(value, Type.INT_TYPE);
        SwitchTable sw = new SwitchTable(value);
        HashMap<Label, List> keyMap = new HashMap<Label, List>();
        for (int i = 0; i < keys.length; ++i) {
            if (labels[i] == dflt) continue;
            keyMap.computeIfAbsent(labels[i], e -> new LinkedList()).add(new LdcNumber(keys[i]));
        }
        keyMap.computeIfAbsent(dflt, e -> new LinkedList()).add(new Nop());
        FastStream.of(keyMap.entrySet()).sorted(Comparator.comparingInt(e -> this.importantLabels.getInt(e.getKey()))).forEach(e -> {
            SwitchTable.SwitchSection section = new SwitchTable.SwitchSection(new Branch(this.getBlock((Label)e.getKey())));
            section.values.addAll((Iterable)e.getValue());
            sw.sections.add(section);
        });
        this.addInsn(sw);
    }

    public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
        this.addInsn(this.push(new NewArray((ArrayType)this.typeResolver.resolveType(Type.getType((String)descriptor)), false, this.popMany(numDimensions)), TypeResolver.OBJECT_TYPE));
    }

    public void visitFrame(int type, int numLocal, Object[] locals, int numStack, Object[] stacks) {
        assert (this.currentStack.size() == numStack);
    }

    public void visitLineNumber(int line, Label start) {
        this.sourceLineNumber = line;
    }

    private boolean isWide(LocalVariable var) {
        AType declType = var.getType();
        return declType == PrimitiveType.DOUBLE || declType == PrimitiveType.LONG;
    }

    private void assertStackType(AType type, Type expectedStackType) {
        if (type == PrimitiveType.BOOLEAN && expectedStackType == Type.BYTE_TYPE || expectedStackType == Type.INT_TYPE) {
            return;
        }
        assert (TypeSystem.isAssignableTo(type, this.typeResolver.resolveType(expectedStackType)));
    }

    private void assertStackType(Instruction insn, Type expectedStackType) {
        this.assertStackType(insn.getResultType(), expectedStackType);
    }

    private static Block getHandlerBlock(TryCatch tryCatch) {
        return ((Branch)((TryCatch.TryCatchHandler)tryCatch.handlers.only()).getBody().getEntryPoint().instructions.only()).getTargetBlock();
    }

    @Nullable
    private static Label getFirstLabel(MethodNode mNode) {
        for (AbstractInsnNode instruction : mNode.instructions) {
            if (instruction.getType() != 8) continue;
            return ((LabelNode)instruction).getLabel();
        }
        return null;
    }

    private static Object2IntMap<Label> computeImportantLabels(MethodNode mNode) {
        Object2IntOpenHashMap labelNames = new Object2IntOpenHashMap();
        HashSet<Label> importantLabels = new HashSet<Label>();
        importantLabels.add(Objects.requireNonNull(InstructionReader.getFirstLabel(mNode)));
        for (AbstractInsnNode insn : mNode.instructions) {
            switch (insn.getType()) {
                case 8: {
                    LabelNode lNode = (LabelNode)insn;
                    labelNames.put((Object)lNode.getLabel(), labelNames.size());
                    break;
                }
                case 7: {
                    importantLabels.add(((JumpInsnNode)insn).label.getLabel());
                    break;
                }
                case 11: {
                    TableSwitchInsnNode tsinsn = (TableSwitchInsnNode)insn;
                    importantLabels.add(tsinsn.dflt.getLabel());
                    tsinsn.labels.forEach(e -> importantLabels.add(e.getLabel()));
                    break;
                }
                case 12: {
                    LookupSwitchInsnNode lsinsn = (LookupSwitchInsnNode)insn;
                    importantLabels.add(lsinsn.dflt.getLabel());
                    lsinsn.labels.forEach(e -> importantLabels.add(e.getLabel()));
                }
            }
        }
        for (TryCatchBlockNode tryCatchBlock : mNode.tryCatchBlocks) {
            importantLabels.add(tryCatchBlock.start.getLabel());
            importantLabels.add(tryCatchBlock.end.getLabel());
            importantLabels.add(tryCatchBlock.handler.getLabel());
        }
        Object2IntOpenHashMap ret = new Object2IntOpenHashMap();
        for (Label label : importantLabels) {
            assert (labelNames.containsKey((Object)label));
            ret.put((Object)label, labelNames.getInt((Object)label));
        }
        return ret;
    }
}

