/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import com.google.common.collect.HashMultimap;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.ForEachLoop;
import net.covers1624.coffeegrinder.bytecode.insns.ForLoop;
import net.covers1624.coffeegrinder.bytecode.insns.LocalReference;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.TryCatch;
import net.covers1624.coffeegrinder.bytecode.insns.TryWithResources;
import net.covers1624.coffeegrinder.bytecode.matching.LoadStoreMatching;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;
import net.covers1624.coffeegrinder.util.None;
import net.covers1624.quack.collection.FastStream;
import org.jetbrains.annotations.Nullable;

public class VariableDeclarations
extends SimpleInsnVisitor<None>
implements MethodTransformer {
    private final Map<LocalVariable, Instruction> varDeclPoints = new LinkedHashMap<LocalVariable, Instruction>();

    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        this.varDeclPoints.clear();
        function.accept(this);
        HashMultimap aliasedDeclarations = HashMultimap.create();
        for (Map.Entry<LocalVariable, Instruction> entry : this.varDeclPoints.entrySet()) {
            LocalVariable var = entry.getKey();
            Instruction declPoint = entry.getValue();
            LocalVariable aliasInScope = this.getDeclarationInScopeIfAny(aliasedDeclarations.get((Object)var.getName()), declPoint);
            if (aliasInScope != null && this.replaceVariable(var, aliasInScope, ctx)) continue;
            if (!this.isDeclaration(declPoint, var)) {
                ctx.pushStep("Declare " + var.getUniqueName() + " in outer scope");
                LocalReference newDecl = new LocalReference(var);
                declPoint.insertBefore(newDecl);
                declPoint = newDecl;
                ctx.popStep();
            }
            aliasedDeclarations.put((Object)var.getName(), (Object)new AliasedDeclaration(declPoint, var));
        }
    }

    private boolean isDeclaration(Instruction declPoint, LocalVariable var) {
        return LoadStoreMatching.matchLocalRef(declPoint, var) != null || LoadStoreMatching.matchStoreLocal(declPoint, var) != null;
    }

    @Nullable
    private LocalVariable getDeclarationInScopeIfAny(Collection<AliasedDeclaration> aliasedDeclarations, Instruction usage) {
        return (LocalVariable)FastStream.of(aliasedDeclarations).filter(pair -> usage.isDescendantOf(pair.declPoint.getParent())).map(e -> e.var).onlyOrDefault();
    }

    private boolean replaceVariable(LocalVariable var, LocalVariable replacement, MethodTransformContext ctx) {
        if (!var.getType().equals(replacement.getType()) || var.getIndex() != replacement.getIndex()) {
            return false;
        }
        ctx.pushStep("Merge variable " + var.getUniqueName() + " into " + replacement.getUniqueName());
        List.copyOf(var.getReferences()).forEach(r -> r.replaceWith(new LocalReference(replacement)));
        ctx.popStep();
        return true;
    }

    public static Instruction unifyUsages(Instruction decl, Instruction usage) {
        Instruction commonParent = VariableDeclarations.findCommonParent(decl, usage);
        if (VariableDeclarations.isDeclInInitializerSlot(decl, commonParent)) {
            return decl;
        }
        if (commonParent instanceof Block) {
            return VariableDeclarations.findAncestorChild(decl, commonParent);
        }
        return VariableDeclarations.selectDeclarableParent(commonParent);
    }

    private static boolean isDeclInInitializerSlot(Instruction decl, Instruction commonParent) {
        if (commonParent instanceof ForLoop || commonParent instanceof TryWithResources || commonParent instanceof ForEachLoop || commonParent instanceof TryCatch.TryCatchHandler) {
            return commonParent.getFirstChild() == decl;
        }
        return false;
    }

    public static Instruction selectDeclarableParent(Instruction insn) {
        while (!(insn.getParent() instanceof Block)) {
            if (!((insn = insn.getParent()) instanceof MethodDecl)) continue;
            MethodDecl mDecl = (MethodDecl)insn;
            return mDecl.getBody().getEntryPoint().getFirstChild();
        }
        return insn;
    }

    private static Instruction findAncestorChild(Instruction insn, Instruction ancestor) {
        while (insn.getParent() != ancestor) {
            insn = insn.getParent();
        }
        return insn;
    }

    private static Instruction findCommonParent(Instruction decl, Instruction use2) {
        Instruction parent = decl;
        while (!use2.isDescendantOf(parent = parent.getParent())) {
        }
        return parent;
    }

    @Override
    public None visitLocalReference(LocalReference localRef, None ctx) {
        LocalVariable var = localRef.variable;
        if (var.getKind() == LocalVariable.VariableKind.PARAMETER) {
            return NONE;
        }
        Instruction scope = localRef.getParent() instanceof Store ? localRef.getParent() : localRef;
        Instruction decl = this.varDeclPoints.get(var);
        if (decl == null) {
            assert (localRef.isWrittenTo());
            this.varDeclPoints.put(var, scope);
        } else {
            this.varDeclPoints.put(var, VariableDeclarations.unifyUsages(decl, scope));
        }
        return NONE;
    }

    private record AliasedDeclaration(Instruction declPoint, LocalVariable var) {
    }
}

