/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type.asm;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.ITypeParameterizedMember;
import net.covers1624.coffeegrinder.type.ParameterizedClass;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.type.WildcardType;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public abstract class ReferenceTypeSignatureParser
extends SignatureVisitor {
    private final TypeResolver typeResolver;
    private final ITypeParameterizedMember scope;
    @Nullable
    private ParameterizedClass paramaterizedOuter;
    @Nullable
    private ClassType currentType;
    private final List<ReferenceType> currentArguments = new LinkedList<ReferenceType>();

    protected ReferenceTypeSignatureParser(TypeResolver typeResolver, ITypeParameterizedMember scope) {
        super(589824);
        this.typeResolver = typeResolver;
        this.scope = scope;
    }

    public static ReferenceType parse(TypeResolver typeResolver, ITypeParameterizedMember scope, String signature) {
        final AtomicReference referenceType = new AtomicReference();
        new SignatureReader(signature).accept((SignatureVisitor)new ReferenceTypeSignatureParser(typeResolver, scope){

            @Override
            public void endType(AType type) {
                referenceType.set((ReferenceType)type);
            }
        });
        return Objects.requireNonNull((ReferenceType)referenceType.get(), "Didn't parse anything??");
    }

    public void visitBaseType(char descriptor) {
        this.endType(this.typeResolver.resolveType(Type.getType((String)String.valueOf(descriptor))));
    }

    public void visitTypeVariable(String name) {
        this.endType(Objects.requireNonNull(this.scope.resolveTypeParameter(name)));
    }

    public SignatureVisitor visitArrayType() {
        return new ReferenceTypeSignatureParser(this.typeResolver, this.scope){

            @Override
            public void endType(AType type) {
                ReferenceTypeSignatureParser.this.endType(ReferenceTypeSignatureParser.this.typeResolver.makeArray(type));
            }
        };
    }

    public void visitClassType(String name) {
        this.currentType = this.typeResolver.resolveClassDecl(name);
    }

    public void visitTypeArgument() {
        this.currentArguments.add(WildcardType.createExtends(this.typeResolver.resolveClass(TypeResolver.OBJECT_TYPE)));
    }

    public void visitInnerClassType(String name) {
        assert (this.currentType != null);
        this.paramaterizedOuter = new ParameterizedClass(this.paramaterizedOuter, this.currentType, List.copyOf(this.currentArguments));
        this.currentType = this.typeResolver.resolveClassDecl(this.currentType.getFullName() + "$" + name);
        this.currentArguments.clear();
    }

    public SignatureVisitor visitTypeArgument(final char wildcard) {
        return new ReferenceTypeSignatureParser(this.typeResolver, this.scope){

            @Override
            public void endType(AType type) {
                switch (wildcard) {
                    case '+': {
                        ReferenceTypeSignatureParser.this.currentArguments.add(WildcardType.createExtends((ReferenceType)type));
                        break;
                    }
                    case '-': {
                        ReferenceTypeSignatureParser.this.currentArguments.add(WildcardType.createSuper((ReferenceType)type));
                        break;
                    }
                    case '=': {
                        ReferenceTypeSignatureParser.this.currentArguments.add((ReferenceType)type);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("" + wildcard);
                    }
                }
            }
        };
    }

    public void visitEnd() {
        assert (this.currentType != null);
        if (!this.currentArguments.isEmpty() || this.paramaterizedOuter != null) {
            this.endType(new ParameterizedClass(this.paramaterizedOuter, this.currentType, List.copyOf(this.currentArguments)));
            return;
        }
        if (TypeSystem.isGeneric(this.currentType)) {
            this.endType(this.currentType.asRaw());
            return;
        }
        this.endType(this.currentType);
    }

    public abstract void endType(AType var1);
}

