/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers.statement;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.Binary;
import net.covers1624.coffeegrinder.bytecode.insns.BinaryOp;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.InvokeDynamic;
import net.covers1624.coffeegrinder.bytecode.insns.LdcString;
import net.covers1624.coffeegrinder.bytecode.insns.New;
import net.covers1624.coffeegrinder.bytecode.matching.InvokeMatching;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.StatementTransformer;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.util.None;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;

public class StringConcat
extends SimpleInsnVisitor<StatementTransformContext>
implements StatementTransformer {
    private static final char TAG_ARG = '\u0001';
    private static final char TAG_CONST = '\u0002';
    private final ClassType string;
    @Nullable
    private final ClassType stringConcatFactory;
    private final ClassType stringBuilder;
    private final Method sb_toString;

    public StringConcat(TypeResolver typeResolver) {
        this.string = typeResolver.resolveClassDecl(TypeResolver.STRING_TYPE);
        this.stringConcatFactory = typeResolver.tryResolveClassDecl("java/lang/invoke/StringConcatFactory");
        this.stringBuilder = typeResolver.resolveClassDecl("java/lang/StringBuilder");
        this.sb_toString = Objects.requireNonNull(this.stringBuilder.resolveMethod("toString", Type.getMethodType((String)"()Ljava/lang/String;")));
    }

    @Override
    public void transform(Instruction statement, StatementTransformContext ctx) {
        statement.accept(this, ctx);
    }

    @Override
    public None visitInvokeDynamic(InvokeDynamic indy, StatementTransformContext ctx) {
        super.visitInvokeDynamic(indy, ctx);
        if (this.stringConcatFactory == null) {
            return NONE;
        }
        InvokeDynamic makeConcat = InvokeMatching.matchInvokeDynamic(indy, this.stringConcatFactory, "makeConcat");
        if (makeConcat != null) {
            this.makeStringConcat(makeConcat, makeConcat.arguments.toList(), ctx);
            return NONE;
        }
        InvokeDynamic makeConcatWithConstants = InvokeMatching.matchInvokeDynamic(indy, this.stringConcatFactory, "makeConcatWithConstants");
        if (makeConcatWithConstants != null) {
            List<Instruction> concatArgs = this.parseConcatWithConstants(makeConcatWithConstants);
            this.makeStringConcat(makeConcatWithConstants, concatArgs, ctx);
            return NONE;
        }
        return NONE;
    }

    @Override
    public None visitInvoke(Invoke invoke, StatementTransformContext ctx) {
        super.visitInvoke(invoke, ctx);
        Invoke toString = InvokeMatching.matchInvoke((Instruction)invoke, Invoke.InvokeKind.VIRTUAL, this.sb_toString);
        if (toString != null) {
            this.transformStringConcat(toString, ctx);
        }
        return NONE;
    }

    private void transformStringConcat(Invoke invoke, StatementTransformContext ctx) {
        List<Instruction> appendChain = this.followAppendChain(invoke.getTarget());
        if (appendChain.size() <= 1) {
            return;
        }
        this.makeStringConcat(invoke, appendChain, ctx);
    }

    private List<Instruction> followAppendChain(Instruction start) {
        LinkedList<Instruction> appendChain = new LinkedList<Instruction>();
        Instruction next = start;
        while (!this.isStringBuilderNew(next)) {
            Instruction arg = this.getAppendArgument(next);
            if (arg == null) {
                return Collections.emptyList();
            }
            next = ((Invoke)next).getTarget();
            appendChain.addFirst(arg);
        }
        return appendChain;
    }

    @Nullable
    private Instruction getAppendArgument(Instruction insn) {
        Invoke append = InvokeMatching.matchInvoke(insn, Invoke.InvokeKind.VIRTUAL, "append");
        if (append == null) {
            return null;
        }
        Method method = append.getMethod();
        if (method.getDeclaringClass().getDeclaration() != this.stringBuilder) {
            return null;
        }
        if (append.getArguments().size() != 1) {
            return null;
        }
        return (Instruction)append.getArguments().first();
    }

    private boolean isStringBuilderNew(Instruction insn) {
        if (!(insn instanceof New)) {
            return false;
        }
        New newInsn = (New)insn;
        Method method = newInsn.getMethod();
        return method.getName().equals("<init>") && newInsn.getArguments().isEmpty() && method.getDeclaringClass().getDeclaration() == this.stringBuilder;
    }

    private List<Instruction> parseConcatWithConstants(InvokeDynamic indy) {
        ArrayList<Instruction> concatArgs = new ArrayList<Instruction>();
        int argIdx = 0;
        String recipe = (String)indy.bootstrapArguments[0];
        StringBuilder builder = new StringBuilder();
        for (char c : recipe.toCharArray()) {
            if (c == '\u0001' || c == '\u0002') {
                if (!builder.isEmpty()) {
                    concatArgs.add(new LdcString(this.string, builder.toString()));
                    builder.setLength(0);
                }
                concatArgs.add(indy.arguments.get(argIdx++));
                continue;
            }
            builder.append(c);
        }
        if (!builder.isEmpty()) {
            concatArgs.add(new LdcString(this.string, builder.toString()));
        }
        return concatArgs;
    }

    private void makeStringConcat(Instruction toReplace, List<Instruction> concatArgs, StatementTransformContext ctx) {
        if (!ColUtils.anyMatch(concatArgs, e -> e.getResultType().equals(this.string))) {
            concatArgs.addFirst(new LdcString(this.string, ""));
        }
        Instruction concat = (Instruction)FastStream.of(concatArgs).fold((a, b) -> new Binary(BinaryOp.ADD, (Instruction)a, (Instruction)b)).orElseThrow(SneakyUtils.notPossible());
        ctx.pushStep("Produce string concat");
        toReplace.replaceWith(concat.withOffsets(toReplace));
        ctx.popStep();
    }
}

