package net.covers1624.coffeegrinder.type;

import net.covers1624.quack.collection.FastStream;

import java.util.HashSet;
import java.util.List;

/**
 * Created by covers1624 on 23/7/21.
 */
public class IntegerConstantUnion extends AType {

    private final List<IntegerConstantType> types;

    public IntegerConstantUnion(List<IntegerConstantType> types) {
        this.types = List.copyOf(types);
        assert types.size() > 1;
        assert new HashSet<>(types).size() == types.size();
    }

    @Override
    public String getName() {
        return FastStream.of(types).map(AType::getName).join(" | ");
    }

    @Override
    public String getFullName() {
        return FastStream.of(types).map(AType::getFullName).join(" | ");
    }

    public List<IntegerConstantType> getTypes() {
        return types;
    }

    @Override
    public String toString() {
        return "IntegerConstantUnion(" + FastStream.of(types).map(Object::toString).join(" | ") + ")";
    }
}
