package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.ArrayType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

import java.util.Arrays;

/**
 * Created by covers1624 on 1/4/21.
 */
public final class NewArray extends Instruction {

    private ArrayType type;
    public final boolean isInitializer;
    private final InstructionCollection<Instruction> children = new InstructionCollection<>(this);

    public NewArray(ArrayType type, boolean isInitializer, Iterable<Instruction> children) {
        this.type = type;
        this.isInitializer = isInitializer;
        this.children.addAll(children);
    }

    public NewArray(ArrayType type, boolean isInitializer, Instruction... children) {
        this(type, isInitializer, Arrays.asList(children));
    }

    @Override
    public ArrayType getResultType() {
        return type;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.MAY_THROW.toSet();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitNewArray(this, ctx);
    }

    //@formatter:off
    public ArrayType getType() { return type; }
    public void setType(ArrayType type) { this.type = type; }
    public InstructionCollection<Instruction> getIndices() { if ( isInitializer) throw new IllegalStateException("Does not have indicies."); return children; }
    public InstructionCollection<Instruction> getValues()  { if (!isInitializer) throw new IllegalStateException("Does not have values.")  ; return children; }
    //@formatter:on
}
