package net.covers1624.coffeegrinder.bytecode.insns;

import net.covers1624.coffeegrinder.bytecode.*;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

/**
 * Created by covers1624 on 9/2/24.
 */
public final class Yield extends Instruction {

    private final InstructionSlot<Instruction> value = new InstructionSlot<>(this);
    private final Switch swtch;

    public Yield(Switch swtch, Instruction value) {
        this.swtch = swtch;
        this.value.set(value);
    }

    public Instruction getValue() {
        return value.get();
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.END_POINT_UNREACHABLE.toSet();
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitYield(this, ctx);
    }

    @Override
    protected void onConnected() {
        super.onConnected();
        swtch.addYield(this);
    }

    @Override
    protected void onDisconnected() {
        super.onDisconnected();
        swtch.remYield(this);
    }

    public Switch getSwitch() {
        return swtch;
    }
}
