/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j.reporting.tooling.spi.htmlreport;

import java.util.ArrayList;
import java.util.Objects;
import org.opentest4j.reporting.tooling.spi.htmlreport.Image;

final class ImmutableImage
implements Image {
    private final String content;
    private final String altText;

    private ImmutableImage(String content, String altText) {
        this.content = content;
        this.altText = altText;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    @Override
    public String getAltText() {
        return this.altText;
    }

    public final ImmutableImage withContent(String value) {
        String newValue = Objects.requireNonNull(value, "content");
        if (this.content.equals(newValue)) {
            return this;
        }
        return new ImmutableImage(newValue, this.altText);
    }

    public final ImmutableImage withAltText(String value) {
        String newValue = Objects.requireNonNull(value, "altText");
        if (this.altText.equals(newValue)) {
            return this;
        }
        return new ImmutableImage(this.content, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableImage && this.equalTo(0, (ImmutableImage)another);
    }

    private boolean equalTo(int synthetic, ImmutableImage another) {
        return this.content.equals(another.content) && this.altText.equals(another.altText);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.content.hashCode();
        h += (h << 5) + this.altText.hashCode();
        return h;
    }

    public String toString() {
        return "Image{content=" + this.content + ", altText=" + this.altText + "}";
    }

    public static Image copyOf(Image instance) {
        if (instance instanceof ImmutableImage) {
            return (ImmutableImage)instance;
        }
        return new Image.Builder().content((String)instance.getContent()).altText(instance.getAltText()).build();
    }

    public static class Builder {
        private static final long INIT_BIT_CONTENT = 1L;
        private static final long INIT_BIT_ALT_TEXT = 2L;
        private long initBits = 3L;
        private String content;
        private String altText;

        public Builder() {
            if (!(this instanceof Image.Builder)) {
                throw new UnsupportedOperationException("Use: new Image.Builder()");
            }
        }

        public final Image.Builder content(String content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (Image.Builder)this;
        }

        public final Image.Builder altText(String altText) {
            this.altText = Objects.requireNonNull(altText, "altText");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return (Image.Builder)this;
        }

        public Image build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableImage(this.content, this.altText);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("content");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("altText");
            }
            return "Cannot build Image, some of required attributes are not set " + attributes;
        }
    }
}

