/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.insns;

import java.util.BitSet;
import net.covers1624.coffeegrinder.bytecode.InsnVisitor;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionFlag;
import net.covers1624.coffeegrinder.bytecode.InstructionSlot;
import net.covers1624.coffeegrinder.bytecode.SemanticHelper;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.util.EnumBitSet;

public final class IfInstruction
extends Instruction {
    private final InstructionSlot<Instruction> condition = new InstructionSlot(this);
    private final InstructionSlot<Instruction> trueInsn = new InstructionSlot(this);
    private final InstructionSlot<Instruction> falseInsn = new InstructionSlot(this);

    public IfInstruction(Instruction condition, Instruction trueInsn) {
        this(condition, trueInsn, new Nop());
    }

    public IfInstruction(Instruction condition, Instruction trueInsn, Instruction falseInsn) {
        this.condition.set(condition);
        this.trueInsn.set(trueInsn);
        this.falseInsn.set(falseInsn);
    }

    @Override
    public AType getResultType() {
        return PrimitiveType.VOID;
    }

    @Override
    protected EnumBitSet<InstructionFlag> computeFlags() {
        Object flags = InstructionFlag.NONE.copy();
        ((BitSet)flags).or(this.getDirectFlags());
        ((BitSet)flags).or(this.condition.get().getFlags());
        ((BitSet)flags).or(SemanticHelper.combineBranches(this.getTrueInsn().getFlags(), this.getFalseInsn().getFlags()));
        return flags;
    }

    @Override
    public EnumBitSet<InstructionFlag> getDirectFlags() {
        return InstructionFlag.NONE;
    }

    @Override
    public <R, C> R accept(InsnVisitor<R, C> visitor, C ctx) {
        return visitor.visitIfInstruction(this, ctx);
    }

    public Instruction getCondition() {
        return this.condition.get();
    }

    public Instruction getTrueInsn() {
        return this.trueInsn.get();
    }

    public Instruction getFalseInsn() {
        return this.falseInsn.get();
    }

    public void setCondition(Instruction condition) {
        this.condition.set(condition);
    }

    public void setTrueInsn(Instruction trueInsn) {
        this.trueInsn.set(trueInsn);
    }

    public void setFalseInsn(Instruction falseInsn) {
        this.falseInsn.set(falseInsn);
    }
}

