/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform;

import java.util.LinkedList;
import java.util.List;
import net.covers1624.coffeegrinder.bytecode.InvariantVisitor;
import net.covers1624.coffeegrinder.bytecode.flow.ControlFlowGraph;
import net.covers1624.coffeegrinder.bytecode.flow.ControlFlowNode;
import net.covers1624.coffeegrinder.bytecode.insns.Block;
import net.covers1624.coffeegrinder.bytecode.insns.BlockContainer;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.BlockTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;

public class MethodBlockTransform
implements MethodTransformer {
    private final String name;
    private final List<BlockTransformer> transforms;
    private boolean running;

    public MethodBlockTransform(String name, List<BlockTransformer> transforms) {
        this.name = name;
        this.transforms = List.copyOf(transforms);
        assert (!transforms.isEmpty());
    }

    public static MethodBlockTransform of(String name, BlockTransformer ... transforms) {
        return new MethodBlockTransform(name, List.of(transforms));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transform(MethodDecl function, MethodTransformContext ctx) {
        if (this.running) {
            throw new IllegalStateException("Reentrancy detected.");
        }
        try {
            this.running = true;
            ctx.pushTiming("Find BlockContainers");
            LinkedList<BlockContainer> blocks = function.descendantsToList(BlockContainer.class);
            ctx.popTiming();
            for (BlockContainer container : blocks) {
                ctx.pushTiming("Control Flow Graph");
                ControlFlowGraph graph = new ControlFlowGraph(container);
                ctx.popTiming();
                this.visitBlock(graph, graph.nodes.get(container.getEntryPointOrNull()), ctx);
            }
        }
        finally {
            this.running = false;
        }
    }

    private void visitBlock(ControlFlowGraph graph, ControlFlowNode cfgNode, MethodTransformContext ctx) {
        Block block = cfgNode.getBlock();
        for (ControlFlowNode child : cfgNode.getDominatorTreeChildren()) {
            this.visitBlock(graph, child, ctx);
        }
        BlockTransformContext blockCtx = new BlockTransformContext(ctx, cfgNode, graph);
        blockCtx.pushStep(block.getName());
        for (int i = 0; i < this.transforms.size(); ++i) {
            BlockTransformer t = this.transforms.get(i);
            blockCtx.pushStep(t.getName(), t.stepType());
            t.transform(block, blockCtx);
            InvariantVisitor.checkInvariants(block);
            blockCtx.popStep();
        }
        blockCtx.popStep();
    }

    @Override
    public String getName() {
        return this.name;
    }
}

