/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode.transform.transformers.generics;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.covers1624.coffeegrinder.bytecode.IndexedInstructionCollection;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.AbstractInvoke;
import net.covers1624.coffeegrinder.bytecode.insns.ArrayElementReference;
import net.covers1624.coffeegrinder.bytecode.insns.ArrayLen;
import net.covers1624.coffeegrinder.bytecode.insns.Binary;
import net.covers1624.coffeegrinder.bytecode.insns.Cast;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.bytecode.insns.Comparison;
import net.covers1624.coffeegrinder.bytecode.insns.CompoundAssignment;
import net.covers1624.coffeegrinder.bytecode.insns.FieldDecl;
import net.covers1624.coffeegrinder.bytecode.insns.FieldReference;
import net.covers1624.coffeegrinder.bytecode.insns.ForEachLoop;
import net.covers1624.coffeegrinder.bytecode.insns.InstanceOf;
import net.covers1624.coffeegrinder.bytecode.insns.Invoke;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNull;
import net.covers1624.coffeegrinder.bytecode.insns.Load;
import net.covers1624.coffeegrinder.bytecode.insns.LocalVariable;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.insns.MethodReference;
import net.covers1624.coffeegrinder.bytecode.insns.New;
import net.covers1624.coffeegrinder.bytecode.insns.NewArray;
import net.covers1624.coffeegrinder.bytecode.insns.Nop;
import net.covers1624.coffeegrinder.bytecode.insns.ParameterVariable;
import net.covers1624.coffeegrinder.bytecode.insns.PostIncrement;
import net.covers1624.coffeegrinder.bytecode.insns.Return;
import net.covers1624.coffeegrinder.bytecode.insns.Store;
import net.covers1624.coffeegrinder.bytecode.insns.Switch;
import net.covers1624.coffeegrinder.bytecode.insns.Ternary;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.generics.BoundSet;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.generics.GenericTransformInference;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.generics.TypeHintBoundSet;
import net.covers1624.coffeegrinder.debug.Step;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ArrayCloneMethod;
import net.covers1624.coffeegrinder.type.ArrayType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.GetClassMethod;
import net.covers1624.coffeegrinder.type.ITypeParameterizedMember;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.NullConstantType;
import net.covers1624.coffeegrinder.type.Parameter;
import net.covers1624.coffeegrinder.type.ParameterizedClass;
import net.covers1624.coffeegrinder.type.ParameterizedMethod;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.RawClass;
import net.covers1624.coffeegrinder.type.RawField;
import net.covers1624.coffeegrinder.type.RawMethod;
import net.covers1624.coffeegrinder.type.ReferenceType;
import net.covers1624.coffeegrinder.type.TypeParameter;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.TypeSubstitutions;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.type.TypeVariable;
import net.covers1624.coffeegrinder.type.WildcardType;
import net.covers1624.coffeegrinder.util.None;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.collection.FastStream;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public class GenericTransform
extends SimpleInsnVisitor<ReturnTypeInfo>
implements ClassTransformer {
    private ClassTransformContext ctx;

    @Override
    public void transform(ClassDecl cInsn, ClassTransformContext ctx) {
        if (cInsn.getClazz().getDeclType() != ClassType.DeclType.TOP_LEVEL) {
            return;
        }
        this.ctx = ctx;
        cInsn.accept(new SimpleInsnVisitor<None>(){

            @Override
            public None visitClassDecl(ClassDecl classDecl, None ctx) {
                GenericTransform.this.visitClass(classDecl);
                return (None)super.visitClassDecl(classDecl, ctx);
            }
        });
    }

    @Override
    public None visitClassDecl(ClassDecl classDecl, ReturnTypeInfo ret) {
        return NONE;
    }

    private void visitClass(ClassDecl classDecl) {
        boolean shouldPush;
        boolean bl = shouldPush = classDecl.getClazz().getDeclType() != ClassType.DeclType.TOP_LEVEL;
        if (shouldPush) {
            this.ctx.pushStep(classDecl.getClazz().getName(), Step.StepContextType.CLASS);
        }
        this.visitDefault((Instruction)classDecl, ReturnTypeInfo.NONE);
        if (shouldPush) {
            this.ctx.popStep();
        }
    }

    @Override
    public None visitComparison(Comparison comparison, ReturnTypeInfo ret) {
        if (ret.pass.bind) {
            comparison.getLeft().accept(this, ReturnTypeInfo.NONE);
            comparison.getRight().accept(this, ReturnTypeInfo.NONE);
        }
        return NONE;
    }

    @Override
    public None visitCompoundAssignment(CompoundAssignment comp, ReturnTypeInfo ret) {
        if (ret.pass.bind) {
            comp.getReference().accept(this, ReturnTypeInfo.NONE);
            AType varType = comp.getReference().getType();
            comp.getValue().accept(this, ReturnTypeInfo.assignedTo(varType, Pass.FULL));
        }
        return NONE;
    }

    @Override
    public None visitMethodDecl(MethodDecl methodDecl, ReturnTypeInfo ret) {
        if (methodDecl.getParent() instanceof ClassDecl) {
            assert (ret == ReturnTypeInfo.NONE);
            this.ctx.pushStep(methodDecl.getMethod().getName(), Step.StepContextType.METHOD);
            methodDecl.setReturnType(methodDecl.getMethod().getReturnType());
            super.visitMethodDecl(methodDecl, ReturnTypeInfo.NONE);
            this.ctx.popStep();
            return NONE;
        }
        if (ret.pass.cleanup) {
            ReferenceType fInterfaceType = (ReferenceType)ret.type;
            if (fInterfaceType == null || !TypeSystem.areErasuresEqual(fInterfaceType, methodDecl.getResultType())) {
                fInterfaceType = methodDecl.getResultType();
                ClassType cType = ((ClassType)fInterfaceType).getDeclaration();
                ReturnTypeInfo hint = GenericTransform.explicitTargetTypeHint(cType, Objects.requireNonNull(cType.getFunctionalInterfaceMethod()).getReturnType(), methodDecl.getReturnType(), null, null);
                if (hint.explicitTypeHint != null) {
                    fInterfaceType = hint.explicitTypeHint;
                }
                this.ctx.pushStep("Add explicit lambda type cast");
                methodDecl.replaceWith(new Cast(methodDecl, fInterfaceType));
                this.ctx.popStep();
            }
            if (!this.isParameterized(methodDecl.getResultType())) {
                this.visitLambda(methodDecl, fInterfaceType);
            }
            this.visitDefault((Instruction)methodDecl, ReturnTypeInfo.NONE);
        }
        return NONE;
    }

    public void visitLambda(MethodDecl lambda, ReferenceType fInterfaceType) {
        this.ctx.pushStep("Bind lambda type " + lambda.getMethod().getName());
        lambda.setResultType(fInterfaceType);
        Method fMethod = Objects.requireNonNull(fInterfaceType.getFunctionalInterfaceMethod());
        AType retType = BoundSet.upper(fMethod.getReturnType());
        lambda.setReturnType(retType);
        ArrayList params = lambda.parameters.filterNot(ParameterVariable::isImplicit).toList();
        for (int i = 0; i < params.size(); ++i) {
            ParameterVariable param = (ParameterVariable)params.get(i);
            AType paramType = param.getType();
            AType mParamType = fMethod.getParameters().get(i).getType();
            if (mParamType instanceof WildcardType) {
                WildcardType w = (WildcardType)mParamType;
                mParamType = w.isSuper() ? w.getLowerBound() : w.getUpperBound();
            }
            AType c = mParamType instanceof TypeParameter ? mParamType : BoundSet.getHierarchyCompatibleType(paramType, mParamType);
            param.setType(c);
        }
        FastStream.concat((Iterable[])new Iterable[]{lambda.parameters, lambda.variables}).forEach(variable -> this.visitLocalVariable((LocalVariable)variable, ReturnTypeInfo.NONE));
        for (Return retInsn : lambda.getReturns()) {
            retInsn.getValue().accept(this, ReturnTypeInfo.assignedTo(retType, Pass.BIND));
        }
        this.ctx.popStep();
    }

    @Override
    public None visitFieldDecl(FieldDecl fieldDecl, ReturnTypeInfo ret) {
        assert (ret == ReturnTypeInfo.NONE);
        AType fieldType = fieldDecl.getField().getType();
        fieldDecl.getValue().accept(this, ReturnTypeInfo.assignedTo(fieldType, Pass.FULL));
        this.wrapWithUncheckedCast(fieldDecl.getValue(), fieldType);
        return NONE;
    }

    @Override
    public None visitCheckCast(Cast cast, ReturnTypeInfo ret) {
        if (cast.getType() instanceof ReferenceType) {
            ret = ret.withCast((ReferenceType)cast.getType());
        }
        cast.getArgument().accept(this, ret);
        if (ret.pass.cleanup) {
            this.cleanupCast(cast, ret);
        }
        return NONE;
    }

    private void cleanupCast(Cast cast, ReturnTypeInfo ret) {
        ReferenceType safeGenericSubtype;
        if (TypeSystem.isObject(cast.getType())) {
            return;
        }
        Instruction target = cast.getArgument();
        if (target instanceof Cast || target instanceof LdcNull) {
            return;
        }
        AType resultType = target.getResultType();
        if (!(resultType instanceof ReferenceType)) {
            return;
        }
        if (TypeSystem.isAssignableTo(resultType, cast.getType())) {
            if (cast.getTag() != GenericTransformInference.REQUIRED_CAST_TAG) {
                this.ctx.pushStep("Remove redundant cast");
                cast.replaceWith(target);
                this.ctx.popStep();
            }
            return;
        }
        if (ret.explicitTypeHint == null) {
            return;
        }
        if (this.isParameterized(ret.explicitTypeHint) && TypeSystem.isAssignableTo(safeGenericSubtype = BoundSet.makeRepresentable(BoundSet.getHierarchyCompatibleType((ReferenceType)cast.getType(), (ReferenceType)resultType)), ret.explicitTypeHint)) {
            this.ctx.pushStep("Add known generics to cast");
            cast.setType(safeGenericSubtype);
            this.ctx.popStep();
            return;
        }
        if (GenericTransform.isRepresentable((Instruction)cast, ret.explicitTypeHint) && TypeSystem.isCastableTo((ReferenceType)resultType, ret.explicitTypeHint, true)) {
            this.ctx.pushStep("Add unchecked generics to cast");
            cast.setType(ret.explicitTypeHint);
            this.ctx.popStep();
        }
    }

    private boolean isParameterized(AType type) {
        return type instanceof ParameterizedClass || type instanceof ArrayType && this.isParameterized(((ArrayType)type).getElementType());
    }

    @Override
    public None visitLoad(Load load, ReturnTypeInfo ret) {
        if (ret.pass.bind) {
            load.getReference().accept(this, ret);
        }
        return NONE;
    }

    @Override
    public None visitLocalVariable(LocalVariable localVariable, ReturnTypeInfo ret) {
        assert (ret == ReturnTypeInfo.NONE);
        if (localVariable.getGenericSignature() != null) {
            this.ctx.pushStep("Replace local type " + localVariable.getName());
            localVariable.setType(GenericTransform.getVariableGenericType(localVariable, this.ctx.getTypeResolver()));
            this.ctx.popStep();
        }
        return (None)super.visitLocalVariable(localVariable, ReturnTypeInfo.NONE);
    }

    @Override
    public None visitPostIncrement(PostIncrement postIncrement, ReturnTypeInfo ret) {
        if (ret.pass.bind) {
            postIncrement.getReference().accept(this, ReturnTypeInfo.NONE);
        }
        return NONE;
    }

    @Override
    public None visitInstanceOf(InstanceOf instanceOf, ReturnTypeInfo ret) {
        if (ret.pass.bind) {
            instanceOf.getArgument().accept(this, ReturnTypeInfo.NONE);
        }
        return NONE;
    }

    @Override
    public None visitInvoke(Invoke invoke, ReturnTypeInfo ret) {
        AType paramType;
        int i;
        IndexedInstructionCollection<Instruction> arguments;
        List<Parameter> parameters;
        if (ret.pass.bind) {
            if (!(invoke.getTarget() instanceof Nop)) {
                invoke.getTarget().accept(this, this.explicitTargetTypeHint(invoke.getMethod().getDeclaration(), ret, invoke.getArguments()));
            }
            this.bindMethod(invoke);
            parameters = invoke.getMethod().getParameters();
            arguments = invoke.getArguments();
            for (i = 0; i < arguments.size(); ++i) {
                paramType = parameters.get(i).getType();
                arguments.get(i).accept(this, ReturnTypeInfo.assignedTo(GenericTransform.explicitArgumentTypeHint(invoke, paramType, ret), Pass.BIND));
            }
        }
        if (ret.pass.cleanup) {
            if (GenericTransform.requiresInference(invoke.getMethod())) {
                GenericTransformInference.infer(ret, invoke, this, this.ctx);
            }
            parameters = invoke.getMethod().getParameters();
            arguments = invoke.getArguments();
            for (i = 0; i < arguments.size(); ++i) {
                paramType = parameters.get(i).getType();
                arguments.get(i).accept(this, ReturnTypeInfo.assignedTo(paramType, Pass.CLEANUP));
            }
            this.rawCastTargetIfNecessary(invoke);
            parameters = invoke.getMethod().getParameters();
            arguments = invoke.getArguments();
            for (i = 0; i < arguments.size(); ++i) {
                paramType = parameters.get(i).getType();
                this.wrapWithUncheckedCast(arguments.get(i), paramType);
            }
        }
        return NONE;
    }

    private static boolean requiresInference(Method method) {
        return method.isConstructor() && !TypeSystem.isFullyDefined(method.getDeclaringClass()) || !TypeSystem.isFullyDefined(method);
    }

    private void rawCastTargetIfNecessary(Invoke invoke) {
        Method method = invoke.getMethod();
        if (method.isStatic() || !this.anyArgsAssignedToIncompatibleTypeVariables(method.getParameters(), invoke.getArguments())) {
            return;
        }
        this.ctx.pushStep("Raw cast target of " + method.getName());
        ClassType rawTargetType = method.getDeclaringClass().asRaw();
        Instruction instruction = invoke.getTarget();
        if (instruction instanceof Cast) {
            Cast cast = (Cast)instruction;
            cast.setType(rawTargetType);
        } else {
            instruction = invoke.getTarget();
            if (instruction instanceof New) {
                New newInsn = (New)instruction;
                newInsn.setMethod(newInsn.getMethod().getDeclaration().asRaw());
            } else {
                invoke.getTarget().replaceWith(new Cast(invoke.getTarget(), rawTargetType));
            }
        }
        method = method.getDeclaration().asRaw();
        invoke.setMethod(method);
        List<Parameter> parameters = method.getParameters();
        IndexedInstructionCollection<Instruction> arguments = invoke.getArguments();
        for (int i = 0; i < parameters.size(); ++i) {
            ReferenceType argType;
            Cast argCast;
            Instruction arg = arguments.get(i);
            if (!(arg instanceof Cast) || (argCast = (Cast)arg).getTag() != GenericTransformInference.REQUIRED_CAST_TAG || !TypeSystem.isAssignableTo((AType)(argType = (ReferenceType)argCast.getArgument().getResultType()), parameters.get(i).getType())) continue;
            this.ctx.pushStep("Remove poly inference guard cast");
            argCast.replaceWith(argCast.getArgument());
            this.ctx.popStep();
        }
        this.ctx.popStep();
    }

    private boolean anyArgsAssignedToIncompatibleTypeVariables(List<Parameter> parameters, IndexedInstructionCollection<Instruction> arguments) {
        for (int i = 0; i < parameters.size(); ++i) {
            ReferenceType bound;
            AType pType = parameters.get(i).getType();
            Instruction arg = arguments.get(i);
            if (!(pType instanceof TypeVariable) || TypeSystem.isAssignableTo(arg.getResultType(), pType) || (bound = ((ReferenceType)pType).getLowerBound()) != NullConstantType.INSTANCE && (!(bound instanceof TypeVariable) || bound instanceof TypeParameter)) continue;
            return true;
        }
        return false;
    }

    private static ReturnTypeInfo explicitTargetTypeHint(Field f, ReturnTypeInfo ret) {
        return GenericTransform.explicitTargetTypeHint(f.getDeclaringClass(), f.getType(), ret, null, null);
    }

    private ReturnTypeInfo explicitTargetTypeHint(Method m, ReturnTypeInfo ret, IndexedInstructionCollection<Instruction> arguments) {
        ClassType cdecl = m.getDeclaringClass();
        if (!TypeSystem.isGeneric(cdecl)) {
            return ReturnTypeInfo.NONE;
        }
        LinkedList<Consumer<TypeHintBoundSet>> argBounds = new LinkedList<Consumer<TypeHintBoundSet>>();
        List<Parameter> parameters = m.getParameters();
        for (int i = 0; i < parameters.size(); ++i) {
            AType paramType = parameters.get(i).getType();
            if (!BoundSet.mentionsTypeParamFromClassOrOuter(paramType, cdecl)) continue;
            Instruction arg = arguments.get(i);
            arg.accept(this, ReturnTypeInfo.preBind());
            argBounds.add(b -> b.constrainAssignable(arg, paramType));
        }
        return GenericTransform.explicitTargetTypeHint(cdecl, m.getReturnType(), ret, argBounds.isEmpty() ? null : b -> argBounds.forEach(e -> e.accept(b)), argBounds.isEmpty() ? null : m.getTypeParameters());
    }

    private static ReturnTypeInfo explicitOuterTargetTypeHint(ClassType type, ReturnTypeInfo ret) {
        return GenericTransform.explicitTargetTypeHint(type.getEnclosingClass().orElseThrow(SneakyUtils.notPossible()), (AType)TypeSystem.makeThisType(type), ret, null, null);
    }

    private static ReturnTypeInfo explicitTargetTypeHint(ClassType decl, AType retType, ReturnTypeInfo ret, @Nullable Consumer<TypeHintBoundSet> extraConstraints, @Nullable Iterable<TypeParameter> extraTypeParams) {
        return GenericTransform.explicitTargetTypeHint(decl, retType, ret.expectedType(), extraConstraints, extraTypeParams);
    }

    private static ReturnTypeInfo explicitTargetTypeHint(ClassType decl, AType retType, @Nullable AType expectedRetType, @Nullable Consumer<TypeHintBoundSet> extraConstraints, @Nullable Iterable<TypeParameter> extraTypeParams) {
        ReferenceType hintType;
        boolean retTypeRelatesToClassGenerics;
        assert (decl == decl.getDeclaration());
        if (!TypeSystem.isGeneric(decl)) {
            return ReturnTypeInfo.NONE;
        }
        boolean bl = retTypeRelatesToClassGenerics = expectedRetType != null && (BoundSet.mentionsTypeParamFromClassOrOuter(retType, decl) || GenericTransform.isInnerOf(retType, decl));
        if (!retTypeRelatesToClassGenerics && extraConstraints == null) {
            return ReturnTypeInfo.NONE;
        }
        ParameterizedClass p = (ParameterizedClass)TypeSystem.makeThisType(decl);
        FastStream params = GenericTransform.collectAllTypeParams(decl);
        if (extraTypeParams != null) {
            params = params.concat(extraTypeParams);
        }
        TypeHintBoundSet b = new TypeHintBoundSet((Iterable<TypeParameter>)params, retType);
        if (expectedRetType != null && retType instanceof ReferenceType) {
            b.constrainReturnAssignable((ReferenceType)expectedRetType);
        }
        if (extraConstraints != null) {
            extraConstraints.accept(b);
        }
        return (hintType = b.solveAndApplyTo(p)) == null ? ReturnTypeInfo.NONE : ReturnTypeInfo.explicitHint(hintType);
    }

    private static FastStream<TypeParameter> collectAllTypeParams(ClassType type) {
        FastStream params = FastStream.of(type.getTypeParameters());
        if (TypeSystem.needsOuterParameterization(type)) {
            return params.concat(GenericTransform.collectAllTypeParams(type.getEnclosingClass().orElseThrow(SneakyUtils.notPossible())));
        }
        return params;
    }

    private static AType explicitArgumentTypeHint(AbstractInvoke invoke, AType paramType, ReturnTypeInfo ret) {
        ReferenceType hintType;
        Method m = invoke.getMethod();
        if (!GenericTransform.requiresInference(m) || !BoundSet.mentionsInferrableTypeParam(paramType, m)) {
            return paramType;
        }
        TypeHintBoundSet b = BoundSet.newBoundSet(invoke, TypeHintBoundSet::new);
        if (BoundSet.isPoly(m) && ret.expectedType() != null) {
            b.constrainReturnAssignable((ReferenceType)ret.expectedType());
        }
        return (hintType = b.solveAndApplyTo((ReferenceType)paramType)) == null ? TypeSystem.erase((ReferenceType)paramType) : hintType;
    }

    private static boolean isInnerOf(AType type, ClassType outer) {
        if (!(type instanceof ParameterizedClass)) {
            return false;
        }
        ParameterizedClass pOuter = ((ParameterizedClass)type).getOuter();
        return pOuter != null && ((ClassType)pOuter).getDeclaration() == outer;
    }

    @Override
    public None visitNew(New newInsn, ReturnTypeInfo ret) {
        IndexedInstructionCollection<Instruction> args;
        Instruction target = newInsn.getTarget();
        if (ret.pass.bind) {
            Method method;
            args = newInsn.getArguments();
            if (target != null) {
                target.accept(this, GenericTransform.explicitOuterTargetTypeHint(newInsn.getResultType().getDeclaration(), ret));
            }
            if ((method = newInsn.getMethod()) instanceof RawMethod || newInsn.getResultType() instanceof RawClass) {
                this.ctx.pushStep("bind ctor");
                method = method.getDeclaration();
                if (target != null) {
                    method = this.bindConstructor((ReferenceType)target.getResultType(), method);
                }
                newInsn.setMethod(method);
                this.ctx.popStep();
            }
            List<Parameter> parameters = method.getParameters();
            for (int i = 0; i < args.size(); ++i) {
                Instruction arg = args.get(i);
                if (arg == target) continue;
                AType paramType = parameters.get(i).getType();
                arg.accept(this, ReturnTypeInfo.assignedTo(GenericTransform.explicitArgumentTypeHint(newInsn, paramType, ret), Pass.BIND));
            }
        }
        if (ret.pass.cleanup) {
            if (GenericTransform.requiresInference(newInsn.getMethod())) {
                GenericTransformInference.infer(ret, newInsn, this, this.ctx);
            }
            args = newInsn.getArguments();
            List<Parameter> parameters = newInsn.getMethod().getParameters();
            for (int i = 0; i < args.size(); ++i) {
                if (args.get(i) == target) continue;
                AType paramType = parameters.get(i).getType();
                args.get(i).accept(this, ReturnTypeInfo.assignedTo(paramType, Pass.CLEANUP));
                this.wrapWithUncheckedCast(args.get(i), paramType);
            }
            if (newInsn.hasAnonymousClassDeclaration()) {
                newInsn.getAnonymousClassDeclaration().accept(this, ReturnTypeInfo.NONE);
            }
        }
        return NONE;
    }

    @Override
    public None visitNewArray(NewArray newArray, ReturnTypeInfo ret) {
        if (ret.pass.bind) {
            if (!newArray.isInitializer) {
                return (None)super.visitNewArray(newArray, ReturnTypeInfo.NONE);
            }
            AType t = newArray.getType().getElementType();
            Iterator<Instruction> iterator = newArray.getValues().iterator();
            while (iterator.hasNext()) {
                Instruction value = iterator.next();
                value.accept(this, ReturnTypeInfo.assignedTo(t, Pass.FULL));
            }
        }
        return NONE;
    }

    private Method bindConstructor(ReferenceType targetType, Method ctor) {
        ClassType type = ctor.getDeclaringClass();
        ClassType outerDecl = type.getEnclosingClass().orElseThrow(SneakyUtils.notPossible());
        if (!TypeSystem.isGeneric(outerDecl)) {
            return ctor;
        }
        ClassType outer = TypeSystem.findParameterization(outerDecl, targetType);
        if (outer instanceof RawClass) {
            return ctor;
        }
        ParameterizedClass pOuter = (ParameterizedClass)outer;
        ParameterizedClass pTarget = new ParameterizedClass(pOuter, type, List.of());
        return new ParameterizedMethod(pTarget, ctor, pOuter, false);
    }

    @Override
    public None visitFieldReference(FieldReference fieldRef, ReturnTypeInfo ret) {
        if (!(fieldRef.getTarget() instanceof Nop)) {
            fieldRef.getTarget().accept(this, GenericTransform.explicitTargetTypeHint(fieldRef.getField().getDeclaration(), ret));
        }
        this.bindField(fieldRef);
        return NONE;
    }

    @Override
    public None visitArrayElementReference(ArrayElementReference elemRef, ReturnTypeInfo ret) {
        elemRef.getArray().accept(this, ret.wrapArrayTarget((ArrayType)elemRef.getArray().getResultType()));
        if (ret.pass.bind) {
            elemRef.getIndex().accept(this, ReturnTypeInfo.NONE);
        }
        return NONE;
    }

    @Override
    public None visitArrayLen(ArrayLen arrayLen, ReturnTypeInfo ret) {
        if (ret.pass.bind) {
            arrayLen.getArray().accept(this, ReturnTypeInfo.NONE);
        }
        return NONE;
    }

    @Override
    public None visitBinary(Binary binary, ReturnTypeInfo ret) {
        if (ret.pass.bind) {
            super.visitBinary(binary, ReturnTypeInfo.NONE);
        }
        return NONE;
    }

    @Override
    public None visitForEachLoop(ForEachLoop forEachLoop, ReturnTypeInfo ret) {
        ReferenceType iteratorTargetType;
        assert (ret == ReturnTypeInfo.NONE);
        forEachLoop.getVariable().accept(this, ReturnTypeInfo.NONE);
        AType variableType = forEachLoop.getVariable().getType();
        ReferenceType iteratorType = (ReferenceType)forEachLoop.getIterator().getResultType();
        if (!(iteratorType instanceof ArrayType)) {
            ClassType iterable = this.ctx.getTypeResolver().resolveClass(Iterable.class).getDeclaration();
            iteratorTargetType = new ParameterizedClass(null, iterable, List.of(WildcardType.createExtends((ReferenceType)variableType)));
        } else {
            ArrayType arrayType = (ArrayType)iteratorType;
            iteratorTargetType = arrayType.withElementType(variableType);
        }
        forEachLoop.getIterator().accept(this, ReturnTypeInfo.explicitHint(iteratorTargetType));
        this.wrapWithUncheckedCast(forEachLoop.getIterator(), iteratorTargetType);
        forEachLoop.getBody().accept(this, ReturnTypeInfo.NONE);
        return NONE;
    }

    @Override
    public None visitStore(Store store, ReturnTypeInfo ret) {
        if (ret.pass.bind) {
            store.getReference().accept(this, ReturnTypeInfo.NONE);
            AType varType = store.getReference().getType();
            store.getValue().accept(this, ReturnTypeInfo.assignedTo(varType, Pass.FULL));
            this.wrapWithUncheckedCast(store.getValue(), varType);
        }
        return NONE;
    }

    @Override
    public None visitSwitch(Switch switchInsn, ReturnTypeInfo ret) {
        switchInsn.getValue().accept(this, ReturnTypeInfo.NONE);
        switchInsn.getBody().accept(this, ReturnTypeInfo.NONE);
        switchInsn.getYields().forEach(e -> e.accept(this, ret));
        return NONE;
    }

    @Override
    public None visitTernary(Ternary ternary, ReturnTypeInfo ret) {
        if (ret.pass.bind) {
            ternary.getCondition().accept(this, ReturnTypeInfo.assignedTo(PrimitiveType.BOOLEAN, Pass.FULL));
        }
        ternary.getTrueInsn().accept(this, ret);
        ternary.getFalseInsn().accept(this, ret);
        return NONE;
    }

    @Override
    public None visitReturn(Return ret, ReturnTypeInfo info) {
        assert (info == ReturnTypeInfo.NONE);
        MethodDecl parent = ret.getMethod();
        boolean isLambda = !(parent.getParent() instanceof ClassDecl);
        AType retType = parent.getReturnType();
        ret.getValue().accept(this, ReturnTypeInfo.assignedTo(retType, isLambda ? Pass.CLEANUP : Pass.FULL));
        this.wrapWithUncheckedCast(ret.getValue(), retType);
        return NONE;
    }

    private void bindField(FieldReference fieldRef) {
        Field iField = fieldRef.getField();
        if (!(iField instanceof RawField)) {
            return;
        }
        Field field = iField.getDeclaration();
        if (!iField.isStatic()) {
            ReferenceType targetType = (ReferenceType)fieldRef.getTarget().getResultType();
            targetType = TypeSystem.findParameterization(field.getDeclaringClass(), targetType);
            if (targetType instanceof RawClass) {
                return;
            }
            if (targetType instanceof ParameterizedClass) {
                field = TypeSubstitutions.applyOwnerParameterization(((ParameterizedClass)targetType).capture(), field);
            }
        }
        this.ctx.pushStep("Bind field " + iField.getName());
        fieldRef.setField(field);
        this.ctx.popStep();
    }

    private void bindMethod(Invoke invoke) {
        Method genericMethod = this.bindMethod(invoke.getTarget(), invoke.getMethod());
        if (genericMethod == null) {
            return;
        }
        this.ctx.pushStep("Bind method " + genericMethod.getName());
        invoke.setMethod(genericMethod);
        this.ctx.popStep();
    }

    @Nullable
    private Method bindMethod(Instruction target, Method iMethod) {
        if (target.getResultType() instanceof ArrayType && iMethod.getName().equals("clone")) {
            return new ArrayCloneMethod((ArrayType)target.getResultType());
        }
        if (!(iMethod instanceof RawMethod)) {
            return null;
        }
        Method method = iMethod.getDeclaration();
        if (target instanceof Nop || method.isStatic()) {
            return method;
        }
        ReferenceType targetType = (ReferenceType)target.getResultType();
        if (method.getName().equals("getClass") && method.getDescriptor().toString().equals("()Ljava/lang/Class;")) {
            targetType = TypeSystem.erase(targetType);
            return new GetClassMethod(targetType, this.ctx.getTypeResolver().resolveClassDecl(TypeResolver.CLASS_TYPE));
        }
        targetType = TypeSystem.findParameterization(method.getDeclaringClass(), targetType);
        if (targetType instanceof RawClass) {
            return null;
        }
        if (targetType instanceof ParameterizedClass) {
            method = TypeSubstitutions.applyOwnerParameterization(((ParameterizedClass)targetType).capture(), method);
        }
        return method;
    }

    @Override
    public None visitMethodReference(MethodReference methodReference, ReturnTypeInfo ret) {
        if (ret.pass.bind) {
            methodReference.getTarget().accept(this, ReturnTypeInfo.NONE);
            this.bindMethod(methodReference);
        }
        if (ret.pass.cleanup) {
            // empty if block
        }
        return NONE;
    }

    private void bindMethod(MethodReference methodReference) {
        Method genericMethod = this.bindMethod(methodReference.getTarget(), methodReference.getMethod());
        if (genericMethod == null) {
            return;
        }
        this.ctx.pushStep("Bind method ref " + genericMethod.getName());
        methodReference.setMethod(genericMethod);
        this.ctx.popStep();
    }

    public void wrapWithUncheckedCast(Instruction arg, AType toType) {
        if (arg instanceof Nop) {
            return;
        }
        if (!(toType instanceof ReferenceType)) {
            return;
        }
        this.wrapWithUncheckedCast(arg, (ReferenceType)toType);
    }

    public void wrapWithUncheckedCast(Instruction arg, ReferenceType toType) {
        ReferenceType uncheckedRawType;
        ReferenceType resultType = (ReferenceType)arg.getResultType();
        if (TypeSystem.isAssignableTo(resultType, toType)) {
            return;
        }
        if (toType.getLowerBound() == NullConstantType.INSTANCE) {
            throw new IllegalStateException("Cannot assign " + String.valueOf(resultType) + " to " + String.valueOf(toType));
        }
        ReferenceType referenceType = uncheckedRawType = (toType = toType.getLowerBound()) instanceof ParameterizedClass ? TypeSystem.erase(toType) : null;
        if (uncheckedRawType != null && !GenericTransform.isRepresentable(arg, toType)) {
            toType = uncheckedRawType;
        }
        this.ctx.pushStep("Wrap with unchecked cast");
        if (!TypeSystem.isCastableTo(resultType, toType, true)) {
            if (uncheckedRawType != null && TypeSystem.isCastableTo(resultType, uncheckedRawType, true)) {
                toType = uncheckedRawType;
            } else {
                this.ctx.pushStep("Wrap with Object cast");
                arg = arg.replaceWith(new Cast(arg, this.ctx.getTypeResolver().resolveType(TypeResolver.OBJECT_TYPE)));
                this.ctx.popStep();
            }
        }
        arg.replaceWith(new Cast(arg, toType));
        this.ctx.popStep();
    }

    public static boolean isRepresentable(Instruction scope, AType type) {
        AType aType = type;
        Objects.requireNonNull(aType);
        AType aType2 = aType;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PrimitiveType.class, ArrayType.class, ParameterizedClass.class, ClassType.class, TypeParameter.class, WildcardType.class}, (Object)aType2, n)) {
            case 0 -> {
                PrimitiveType primitiveType = (PrimitiveType)aType2;
                yield true;
            }
            case 1 -> {
                ArrayType arrayType = (ArrayType)aType2;
                yield GenericTransform.isRepresentable(scope, arrayType.getElementType());
            }
            case 2 -> {
                ParameterizedClass parameterizedClass = (ParameterizedClass)aType2;
                yield GenericTransform.isRepresentable(scope, parameterizedClass);
            }
            case 3 -> {
                ClassType classType = (ClassType)aType2;
                yield true;
            }
            case 4 -> {
                TypeParameter typeParameter = (TypeParameter)aType2;
                yield GenericTransform.typeParameterInScope(scope, typeParameter);
            }
            case 5 -> {
                WildcardType wildcardType = (WildcardType)aType2;
                yield GenericTransform.isRepresentable(scope, wildcardType);
            }
            default -> false;
        };
    }

    private static boolean isRepresentable(Instruction scope, WildcardType wild) {
        return GenericTransform.isRepresentable(scope, wild.isSuper() ? wild.getLowerBound() : wild.getUpperBound());
    }

    private static boolean isRepresentable(Instruction scope, ParameterizedClass clazz) {
        return ColUtils.allMatch(clazz.getTypeArguments(), arg -> GenericTransform.isRepresentable(scope, arg));
    }

    /*
     * Unable to fully structure code
     */
    public static boolean typeParameterInScope(Instruction insn, TypeParameter param) {
        if (!(insn instanceof MethodDecl)) ** GOTO lbl-1000
        mDecl = (MethodDecl)insn;
        if (insn.getParent() instanceof ClassDecl) {
            scope = mDecl.getMethod();
        } else if (insn instanceof ClassDecl) {
            cDecl = (ClassDecl)insn;
            scope = cDecl.getClazz();
        } else {
            return GenericTransform.typeParameterInScope(insn.getParent(), param);
        }
        inScope = scope.resolveTypeParameter(param.getName());
        return inScope == param;
    }

    public static AType getVariableGenericType(LocalVariable variable, TypeResolver typeResolver) {
        ITypeParameterizedMember scope;
        Instruction insn = variable;
        while (true) {
            if (insn instanceof ClassDecl) {
                ClassDecl cDecl = (ClassDecl)insn;
                scope = cDecl.getClazz();
                break;
            }
            if (insn instanceof MethodDecl) {
                MethodDecl mDecl = (MethodDecl)insn;
                if (insn.getParent() instanceof ClassDecl) {
                    scope = mDecl.getMethod();
                    break;
                }
            }
            insn = insn.getParent();
        }
        return typeResolver.resolveGenericType(scope, Objects.requireNonNull(variable.getGenericSignature()));
    }

    public record ReturnTypeInfo(@Nullable AType type, @Nullable ReferenceType cast, @Nullable ReferenceType explicitTypeHint, Pass pass) {
        public static final ReturnTypeInfo NONE = new ReturnTypeInfo(null, null, null, Pass.FULL);

        public static ReturnTypeInfo assignedTo(AType type, Pass pass) {
            assert (!(type instanceof ReferenceType) || TypeSystem.isFullyDefined((ReferenceType)type));
            return new ReturnTypeInfo(type, null, null, pass);
        }

        public static ReturnTypeInfo explicitHint(ReferenceType hint) {
            assert (TypeSystem.isFullyDefined(hint));
            return new ReturnTypeInfo(null, null, hint, Pass.FULL);
        }

        public static ReturnTypeInfo preBind() {
            return new ReturnTypeInfo(null, null, null, Pass.BIND);
        }

        @Nullable
        @Contract(pure=true)
        public AType expectedType() {
            return this.explicitTypeHint != null ? this.explicitTypeHint : this.type;
        }

        public ReturnTypeInfo withCast(ReferenceType cast) {
            return new ReturnTypeInfo(this.type, cast, this.combineTypeHint(cast), this.pass);
        }

        private ReferenceType combineTypeHint(ReferenceType rawHintType) {
            ReferenceType t = (ReferenceType)this.expectedType();
            if (t == null) {
                return rawHintType;
            }
            if (TypeSystem.isAssignableTo(t, rawHintType)) {
                return t;
            }
            return BoundSet.getHierarchyCompatibleType(rawHintType, t);
        }

        public ReturnTypeInfo wrapArrayTarget(ArrayType rawArrayType) {
            AType t = this.expectedType();
            return new ReturnTypeInfo(null, null, t != null ? rawArrayType.withElementType(t) : null, this.pass);
        }
    }

    private static enum Pass {
        BIND(true, false),
        CLEANUP(false, true),
        FULL(true, true);

        public final boolean bind;
        public final boolean cleanup;

        private Pass(boolean bind, boolean cleanup) {
            this.bind = bind;
            this.cleanup = cleanup;
        }
    }
}

