package net.covers1624.coffeegrinder.bytecode.transform.transformers;

import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.SimpleInsnVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformer;
import net.covers1624.coffeegrinder.debug.Step;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.util.None;

import static net.covers1624.coffeegrinder.type.ClassType.DeclType.TOP_LEVEL;

/**
 * Created by covers1624 on 7/7/22.
 */
public class SyntheticCleanup extends SimpleInsnVisitor<ClassTransformContext> implements ClassTransformer {

    @Override
    public void transform(ClassDecl cInsn, ClassTransformContext ctx) {
        if (cInsn.getClazz().getDeclType() == TOP_LEVEL) {
            cInsn.accept(this, ctx);
        }
    }

    @Override
    public None visitClassDecl(ClassDecl classDecl, ClassTransformContext ctx) {
        ClassType cType = classDecl.getClazz();
        Instruction parent = classDecl.getParentOrNull();
        if (parent instanceof ClassDecl && cType.isSynthetic() && classDecl.members.isEmpty()) {
            ctx.pushStep(cType.getName(), Step.StepContextType.CLASS);
            classDecl.remove();
            ctx.popStep();
            return NONE;
        }

        return super.visitClassDecl(classDecl, ctx);
    }

    @Override
    public None visitMethodDecl(MethodDecl methodDecl, ClassTransformContext ctx) {
        Method method = methodDecl.getMethod();
        if (method.isSynthetic() && methodDecl.getParent() instanceof ClassDecl) {
            ctx.pushStep(method.getName(), Step.StepContextType.METHOD);
            methodDecl.remove();
            ctx.popStep();
            return NONE;
        }

        return super.visitMethodDecl(methodDecl, ctx);
    }
}
