/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type.asm;

import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.AnnotationData;
import net.covers1624.coffeegrinder.type.ArrayType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.ParameterizedClass;
import net.covers1624.coffeegrinder.type.TypeAnnotationData;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.TypeSystem;
import net.covers1624.coffeegrinder.type.WildcardType;
import net.covers1624.coffeegrinder.type.asm.AnnotationParser;
import net.covers1624.quack.util.SneakyUtils;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.TypePath;
import org.objectweb.asm.tree.TypeAnnotationNode;

public class TypeAnnotationParser {
    public static void parseTypeAnnotation(TypeResolver resolver, @Nullable AType type, TypeAnnotationNode node, TypeAnnotationData rootNode) {
        TypeAnnotationData location = TypeAnnotationParser.parseTypePath(node.typePath, 0, rootNode, type);
        node.accept((AnnotationVisitor)AnnotationParser.newVisitor(resolver, node.desc, e -> {
            if (!location.annotations.contains(e)) {
                location.annotations.add((AnnotationData)e);
            }
        }));
    }

    private static TypeAnnotationData parseTypePath(@Nullable TypePath path, int step, TypeAnnotationData node, @Nullable AType type) {
        if (path == null && type == null) {
            return node;
        }
        assert (type != null);
        if (type instanceof ArrayType) {
            int arrayDepth = TypeAnnotationParser.arrayDepth(type);
            int depth = 0;
            while (path != null && step < path.getLength() && path.getStep(step) == 0) {
                ++depth;
                ++step;
            }
            if (depth < arrayDepth) {
                depth = arrayDepth - 1 - depth;
            }
            while (depth-- > 0) {
                node = node.addStep(TypeAnnotationData.Target.ARRAY_ELEMENT);
                type = ((ArrayType)type).getElementType();
            }
        }
        if (type instanceof ClassType) {
            ClassType clazz = (ClassType)type;
            if (TypeSystem.isConstructedViaTargetInstance((ClassType)type)) {
                int parameterizedDepth = TypeAnnotationParser.instancedDepth(clazz);
                int depth = 0;
                while (path != null && step < path.getLength() && path.getStep(step) == 1) {
                    ++depth;
                    ++step;
                }
                depth = parameterizedDepth - depth;
                while (depth-- > 0) {
                    node = node.addStep(TypeAnnotationData.Target.OUTER_TYPE);
                    clazz = clazz.getEnclosingClass().orElseThrow(SneakyUtils.notPossible());
                    type = clazz;
                    assert (type != null);
                }
            }
        }
        if (path == null || path.getLength() == step) {
            return node;
        }
        TypeAnnotationData.Target stepType = TypeAnnotationData.Target.values()[path.getStep(step)];
        int stepArg = stepType == TypeAnnotationData.Target.TYPE_ARGUMENT ? path.getStepArgument(step) : 0;
        switch (stepType) {
            case WILDCARD_BOUND: {
                WildcardType wildcardType = (WildcardType)type;
                type = wildcardType.isSuper() ? wildcardType.getLowerBound() : wildcardType.getUpperBound();
                break;
            }
            case TYPE_ARGUMENT: {
                type = ((ParameterizedClass)type).getTypeArguments().get(stepArg);
            }
        }
        return TypeAnnotationParser.parseTypePath(path, step + 1, node.addStep(stepType, stepArg), type);
    }

    private static int arrayDepth(AType type) {
        return type instanceof ArrayType ? 1 + TypeAnnotationParser.arrayDepth(((ArrayType)type).getElementType()) : 0;
    }

    private static int instancedDepth(ClassType clazz) {
        return TypeSystem.isConstructedViaTargetInstance(clazz) ? 1 + TypeAnnotationParser.instancedDepth(clazz.getEnclosingClass().orElseThrow(SneakyUtils.notPossible())) : 0;
    }
}

