/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.type;

import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.covers1624.coffeegrinder.bytecode.AccessFlag;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.TypeParameter;
import net.covers1624.coffeegrinder.util.EnumBitSet;
import net.covers1624.coffeegrinder.util.Util;
import net.covers1624.quack.collection.FastStream;
import org.objectweb.asm.Type;

public class RawClass
extends ClassType {
    private final ClassType decl;
    private final Supplier<ClassType> superClass;
    private final Supplier<List<ClassType>> interfaces;
    private final Supplier<List<Field>> fields;
    private final Supplier<List<Method>> methods;

    public RawClass(ClassType decl) {
        this.decl = decl;
        this.superClass = Util.singleMemoize(() -> decl.getSuperClass().asRaw());
        this.interfaces = Util.singleMemoize(() -> FastStream.of(decl.getInterfaces()).map(ClassType::asRaw).toImmutableList());
        this.fields = Util.singleMemoize(() -> FastStream.of(decl.getFields()).map(Field::asRaw).toImmutableList());
        this.methods = Util.singleMemoize(() -> FastStream.of(decl.getMethods()).map(Method::asRaw).toImmutableList());
    }

    @Override
    public List<ClassType> getNestedClasses() {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Field> getFields() {
        return this.fields.get();
    }

    @Override
    public List<Method> getMethods() {
        return this.methods.get();
    }

    @Override
    public ClassType.DeclType getDeclType() {
        return this.decl.getDeclType();
    }

    @Override
    public String getPackage() {
        return this.decl.getPackage();
    }

    @Override
    public EnumBitSet<AccessFlag> getAccessFlags() {
        return this.decl.getAccessFlags();
    }

    @Override
    public Optional<ClassType> getEnclosingClass() {
        return this.decl.getEnclosingClass().map(ClassType::asRaw);
    }

    @Override
    public Optional<Method> getEnclosingMethod() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Type getDescriptor() {
        return this.decl.getDescriptor();
    }

    @Override
    public ClassType getDeclaration() {
        return this.decl;
    }

    @Override
    public ClassType asRaw() {
        return this;
    }

    @Override
    public ClassType getSuperClass() {
        return this.superClass.get();
    }

    @Override
    public List<ClassType> getInterfaces() {
        return this.interfaces.get();
    }

    @Override
    public String getName() {
        return this.decl.getName();
    }

    @Override
    public List<TypeParameter> getTypeParameters() {
        return List.of();
    }

    @Override
    public String getFullName() {
        return this.decl.getFullName();
    }
}

