/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.coffeegrinder.bytecode;

import java.util.List;
import net.covers1624.coffeegrinder.DecompilerSettings;
import net.covers1624.coffeegrinder.bytecode.Instruction;
import net.covers1624.coffeegrinder.bytecode.InstructionReader;
import net.covers1624.coffeegrinder.bytecode.InvariantVisitor;
import net.covers1624.coffeegrinder.bytecode.insns.ClassDecl;
import net.covers1624.coffeegrinder.bytecode.insns.FieldDecl;
import net.covers1624.coffeegrinder.bytecode.insns.LdcBoolean;
import net.covers1624.coffeegrinder.bytecode.insns.LdcChar;
import net.covers1624.coffeegrinder.bytecode.insns.LdcNumber;
import net.covers1624.coffeegrinder.bytecode.insns.LdcString;
import net.covers1624.coffeegrinder.bytecode.insns.MethodDecl;
import net.covers1624.coffeegrinder.bytecode.transform.BlockStatementTransform;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.ClassTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.ExitPointCleanup;
import net.covers1624.coffeegrinder.bytecode.transform.LabelledBlocks;
import net.covers1624.coffeegrinder.bytecode.transform.MethodBlockTransform;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformContext;
import net.covers1624.coffeegrinder.bytecode.transform.MethodTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.TransformContextBase;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.AssertTransform;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.CompoundAssignments;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.ConditionDetection;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.DetectExitPoints;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.EnumClasses;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.FieldInitializers;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.HighLevelLoops;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.ImplicitConstructorCleanup;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.InnerClasses;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.IntegerConstantInference;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.J11TryWithResourcesTransform;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.Lambdas;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.LegacyTryWithResourcesTransform;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.LocalClasses;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.LoopDetection;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.NumericConstants;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.RecordTransformer;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.SwitchDetection;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.SwitchExpressions;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.SwitchInlining;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.SwitchOnEnum;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.SwitchOnString;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.SynchronizedTransform;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.SyntheticCleanup;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.TryCatches;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.VariableDeclarations;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.generics.GenericTransform;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.AccessorTransforms;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.ArrayInitializers;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.AssignmentExpressions;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.ExpressionTransforms;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.GeneratedNullChecks;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.Inlining;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.NewObjectTransform;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.StringConcat;
import net.covers1624.coffeegrinder.bytecode.transform.transformers.statement.TernaryExpressions;
import net.covers1624.coffeegrinder.debug.Step;
import net.covers1624.coffeegrinder.debug.Stepper;
import net.covers1624.coffeegrinder.type.AType;
import net.covers1624.coffeegrinder.type.ClassType;
import net.covers1624.coffeegrinder.type.Field;
import net.covers1624.coffeegrinder.type.Method;
import net.covers1624.coffeegrinder.type.PrimitiveType;
import net.covers1624.coffeegrinder.type.TypeResolver;
import net.covers1624.coffeegrinder.type.asm.AsmClass;
import net.covers1624.coffeegrinder.type.asm.AsmField;
import net.covers1624.coffeegrinder.util.asm.OrderedTextifier;
import org.objectweb.asm.tree.FieldNode;

public class ClassProcessor {
    private final TypeResolver typeResolver;
    private final ClassType clazz;
    private final DecompilerSettings settings;
    private final List<MethodTransformer> methodTransforms;
    private final List<ClassTransformer> classTransforms;

    public ClassProcessor(TypeResolver typeResolver, ClassType clazz, DecompilerSettings settings) {
        this.typeResolver = typeResolver;
        this.clazz = clazz;
        this.settings = settings;
        this.methodTransforms = List.of(new TryCatches(), new J11TryWithResourcesTransform(typeResolver), new IntegerConstantInference(), MethodBlockTransform.of("Switches", new SwitchDetection()), MethodBlockTransform.of("Loops", new LoopDetection()), new DetectExitPoints(), MethodBlockTransform.of("Conditions and Statements", new ConditionDetection(), BlockStatementTransform.of("Statements", new GeneratedNullChecks(), new TernaryExpressions(), new SwitchExpressions(), new SwitchOnString(), new NewObjectTransform(), new AssignmentExpressions(), new AccessorTransforms(), new Inlining(), new ArrayInitializers(), new StringConcat(typeResolver), new ExpressionTransforms(), new CompoundAssignments()), new LabelledBlocks()), new HighLevelLoops(typeResolver), new ExitPointCleanup(), new LegacyTryWithResourcesTransform(typeResolver), new SynchronizedTransform(), new VariableDeclarations(), new CompoundAssignments(), new SwitchInlining());
        this.classTransforms = List.of(new FieldInitializers(), new Lambdas(typeResolver), new LocalClasses(), new InnerClasses(), new EnumClasses(), new SwitchOnEnum(), new AssertTransform(typeResolver), new SyntheticCleanup(), new RecordTransformer(typeResolver), new ImplicitConstructorCleanup(), new NumericConstants(typeResolver), new GenericTransform());
    }

    public ClassDecl process(Stepper stepper) {
        TransformContextBase baseCtx = new TransformContextBase(stepper, this.typeResolver, this.settings);
        ClassDecl decl = new ClassDecl(this.clazz);
        stepper.pushContext(() -> decl.toString(stepper.getOpts()));
        stepper.pushStepWithContent(this.clazz.getName(), Step.StepContextType.CLASS, () -> OrderedTextifier.textify(((AsmClass)this.clazz).getNode().getNode()));
        decl.addRef();
        for (ClassType nestedClass : this.clazz.getNestedClasses().reversed()) {
            ClassProcessor processor = new ClassProcessor(this.typeResolver, nestedClass, this.settings);
            decl.members.add(processor.process(stepper));
        }
        for (Field field : this.clazz.getFields()) {
            FieldNode node = ((AsmField)field).getNode();
            FieldDecl insn = new FieldDecl(field);
            if (node.value != null) {
                insn.setValue(this.parseFieldConstant(insn.getResultType(), node.value));
            }
            decl.members.add(insn);
        }
        for (Method method : this.clazz.getMethods()) {
            MethodDecl methodDecl = InstructionReader.parse(this.typeResolver, method);
            InvariantVisitor.checkInvariants(methodDecl);
            stepper.pushContext(() -> methodDecl.toString(stepper.getOpts()));
            this.processMethod(baseCtx, methodDecl);
            decl.members.add(methodDecl);
            methodDecl.releaseRef();
            stepper.popContext();
        }
        decl.onParsed();
        this.processClass(baseCtx, decl);
        stepper.popContext();
        stepper.popStep();
        return decl;
    }

    private void processMethod(TransformContextBase baseCtx, MethodDecl decl) {
        MethodTransformContext methodCtx = new MethodTransformContext(baseCtx, decl);
        methodCtx.pushStep(decl.getMethod().getName(), Step.StepContextType.METHOD);
        for (MethodTransformer t : this.methodTransforms) {
            try {
                Step ignored = methodCtx.pushStep(t.getName(), t.stepType());
                try {
                    t.transform(decl, methodCtx);
                    InvariantVisitor.checkInvariants(decl);
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            catch (Throwable e) {
                methodCtx.except(e);
            }
        }
        methodCtx.popStep();
    }

    private void processClass(TransformContextBase baseCtx, ClassDecl decl) {
        ClassTransformContext ctx = new ClassTransformContext(baseCtx, decl);
        for (ClassTransformer t : this.classTransforms) {
            try {
                Step ignored = ctx.pushStep(t.getName(), t.stepType());
                try {
                    t.transform(decl, ctx);
                    InvariantVisitor.checkInvariants(decl);
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                }
            }
            catch (Throwable e) {
                ctx.except(e);
            }
        }
    }

    private Instruction parseFieldConstant(AType desiredType, Object obj) {
        if (desiredType == PrimitiveType.BOOLEAN) {
            return new LdcBoolean((Integer)obj == 1);
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return new LdcString(this.typeResolver.resolveClass(TypeResolver.STRING_TYPE), str);
        }
        if (obj instanceof Number) {
            Number num = (Number)obj;
            if (desiredType == PrimitiveType.CHAR) {
                int intValue = num.intValue();
                assert (intValue >= 0 && intValue <= 65535);
                return new LdcChar((char)intValue);
            }
            return new LdcNumber(num);
        }
        throw new IllegalArgumentException("Unknown field constant type: " + obj.getClass().getName());
    }
}

